/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class PickpocketDebugRenderer {
    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        if (!((Boolean)Config.PICKPOCKETING.enabled.get()).booleanValue()) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        Vec3 view = event.getCamera().getPosition();
        stack.translate(-view.x(), -view.y(), -view.z());
        MultiBufferSource.BufferSource source = mc.renderBuffers().bufferSource();
        for (Player player : mc.level.players()) {
            if (player.isLocalPlayer()) continue;
            stack.pushPose();
            boolean inReach = PickpocketUtil.inReachOfBackpack((LivingEntity)player, (Player)mc.player, (Double)Config.PICKPOCKETING.maxReachDistance.get()) && PickpocketUtil.canSeeBackpack((LivingEntity)player, (Player)mc.player);
            float boxRed = inReach ? 0.0f : 1.0f;
            float boxGreen = inReach ? 1.0f : 1.0f;
            float boxBlue = inReach ? 0.0f : 1.0f;
            float partialTick = event.getPartialTick().getGameTimeDeltaTicks();
            VertexConsumer builder = source.getBuffer(RenderType.lines());
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)builder, (AABB)PickpocketUtil.getBackpackBox((LivingEntity)player, partialTick), (float)boxRed, (float)boxGreen, (float)boxBlue, (float)1.0f);
            float bodyRotation = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot);
            boolean inRange = PickpocketUtil.inRangeOfBackpack((LivingEntity)player, (Player)mc.player);
            float lineRed = inRange ? 0.0f : 1.0f;
            float lineGreen = inRange ? 1.0f : 1.0f;
            float lineBlue = inRange ? 0.0f : 1.0f;
            Matrix4f matrix4f = stack.last().pose();
            Vec3 pos = player.getPosition(partialTick);
            Vec3 start = Vec3.directionFromRotation((float)0.0f, (float)(bodyRotation + 180.0f - ((Double)Config.PICKPOCKETING.maxRangeAngle.get()).floatValue())).scale(((Double)Config.PICKPOCKETING.maxReachDistance.get()).doubleValue());
            Vec3 end = Vec3.directionFromRotation((float)0.0f, (float)(bodyRotation - 180.0f + ((Double)Config.PICKPOCKETING.maxRangeAngle.get()).floatValue())).scale(((Double)Config.PICKPOCKETING.maxReachDistance.get()).doubleValue());
            builder.addVertex(matrix4f, (float)(pos.x + start.x), (float)(pos.y + start.y), (float)(pos.z + start.z)).setColor(lineRed, lineGreen, lineBlue, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix4f, (float)pos.x, (float)pos.y, (float)pos.z).setColor(lineRed, lineGreen, lineBlue, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix4f, (float)(pos.x + end.x), (float)(pos.y + end.y), (float)(pos.z + end.z)).setColor(lineRed, lineGreen, lineBlue, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix4f, (float)pos.x, (float)pos.y, (float)pos.z).setColor(lineRed, lineGreen, lineBlue, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
            stack.popPose();
        }
        source.endBatch(RenderType.lines());
        stack.popPose();
    }
}

