/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Stepper;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.impl.LightweaverAugment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class LightweaverMenu
extends AugmentSettingsMenu {
    private static final Component OPTIONS_LABEL = Component.translatable((String)"backpacked.gui.options");
    private static final Component LIGHT_LEVEL_LABEL = Component.translatable((String)"augment.backpacked.lightweaver.light_level");
    private static final Component PLACE_SOUND_LABEL = Component.translatable((String)"augment.backpacked.lightweaver.place_sound");
    private static final Component LIGHT_LEVEL_TOOLTIP = Component.translatable((String)"augment.backpacked.lightweaver.light_level.tooltip");
    private static final Component PLACE_SOUND_TOOLTIP = Component.translatable((String)"augment.backpacked.lightweaver.place_sound.tooltip");
    private static final int MIN_CONTENT_WIDTH = 130;

    public LightweaverMenu(PopupMenuHandler handler, AugmentHolder<LightweaverAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            LinearLayout layout = LinearLayout.vertical().spacing(2);
            TitleWidget title = (TitleWidget)layout.addChild((LayoutElement)new TitleWidget(OPTIONS_LABEL, Minecraft.getInstance().font));
            Divider divider = (Divider)layout.addChild((LayoutElement)Divider.horizontal(Math.max(130, title.getWidth())).colour(-2044489));
            title.setWidth(divider.getWidth());
            layout.addChild((LayoutElement)LightweaverMenu.createOption(LIGHT_LEVEL_LABEL, LIGHT_LEVEL_TOOLTIP, Stepper.builder().setSize(60, 18).setInitialValue(((LightweaverAugment)holder.get()).minimumLight()).setRange(0, 15).setWrap(true).setOnChange(newValue -> holder.update(((LightweaverAugment)holder.get()).setMinimumLight((int)newValue))).build(), divider.getWidth()));
            layout.addChild((LayoutElement)LightweaverMenu.createOption(PLACE_SOUND_LABEL, PLACE_SOUND_TOOLTIP, (AbstractWidget)CustomButton.state(() -> ((LightweaverAugment)holder.get()).sound(), newValue -> holder.update(((LightweaverAugment)holder.get()).setSound((boolean)newValue))).setMessage(() -> CommonComponents.optionStatus((boolean)((LightweaverAugment)holder.get()).sound())).setSize(60, 18).build(), divider.getWidth()));
            return layout;
        });
    }
}

