/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageCheckShelfKey;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class RecallMenu
extends AugmentSettingsMenu {
    private static final Component OPTIONS_LABEL = Component.translatable((String)"backpacked.gui.options");
    private static final Component SET_SHELF_LABEL = Component.translatable((String)"augment.backpacked.recall.link_shelf");
    private static final Component SET_SHELF_TOOLTIP = Component.translatable((String)"augment.backpacked.recall.link_shelf.tooltip");
    private static final Component CHECKING_STATUS_LABEL = Component.translatable((String)"augment.backpacked.recall.status.checking");
    private static final Component NOT_SET_LABEL = Component.translatable((String)"augment.backpacked.recall.status.no_shelf_linked");
    private static final Component NO_SHELF_LABEL = Component.translatable((String)"augment.backpacked.recall.status.shelf_missing");
    private static final int MIN_CONTENT_WIDTH = 110;

    public RecallMenu(PopupMenuHandler handler, AugmentHolder<RecallAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            LinearLayout layout = LinearLayout.vertical().spacing(2);
            TitleWidget title = (TitleWidget)layout.addChild((LayoutElement)new TitleWidget(OPTIONS_LABEL, Minecraft.getInstance().font));
            Divider divider = (Divider)layout.addChild((LayoutElement)Divider.horizontal(Math.max(110, title.getWidth())).colour(-2044489));
            title.setWidth(divider.getWidth());
            ShelfStatus status = (ShelfStatus)layout.addChild((LayoutElement)new ShelfStatus(108, 16, holder), LayoutSettings::alignHorizontallyCenter);
            status.check();
            layout.addChild((LayoutElement)CustomButton.builder().setSize(110, 20).setMessage(SET_SHELF_LABEL).setTooltip(btn -> {
                if (!btn.isActive()) {
                    return Tooltip.create((Component)SET_SHELF_TOOLTIP);
                }
                return null;
            }).setTooltipDelay(0).setActive(() -> {
                HitResult patt0$temp;
                Minecraft mc = Minecraft.getInstance();
                if (mc.level == null || mc.player == null || !((patt0$temp = mc.hitResult) instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult result = (BlockHitResult)patt0$temp;
                BlockPos pos = result.getBlockPos();
                if (pos.distToCenterSqr((Position)mc.player.getEyePosition()) > 256.0) {
                    return false;
                }
                BlockEntity patt1$temp = mc.level.getBlockEntity(pos);
                if (!(patt1$temp instanceof ShelfBlockEntity)) {
                    return false;
                }
                ShelfBlockEntity shelf = (ShelfBlockEntity)patt1$temp;
                return !Objects.equals(((RecallAugment)holder.get()).shelfKey().orElse(null), shelf.key());
            }).setAction(btn -> {
                BlockHitResult result;
                BlockPos pos;
                BlockEntity patt1$temp;
                HitResult patt0$temp;
                Minecraft mc = Minecraft.getInstance();
                if (mc.level != null && (patt0$temp = mc.hitResult) instanceof BlockHitResult && (patt1$temp = mc.level.getBlockEntity(pos = (result = (BlockHitResult)patt0$temp).getBlockPos())) instanceof ShelfBlockEntity) {
                    ShelfBlockEntity shelf = (ShelfBlockEntity)patt1$temp;
                    if (!Objects.equals(((RecallAugment)holder.get()).shelfKey().orElse(null), shelf.key())) {
                        holder.update(((RecallAugment)holder.get()).setShelfKey(shelf.key()));
                        status.check();
                    }
                }
            }).build());
            return layout;
        });
    }

    public static class ShelfStatus
    extends AbstractWidget {
        private static final WeakHashMap<Key, Consumer<Boolean>> PENDING = new WeakHashMap();
        private static final ResourceLocation SHELF_STATUS_DEFAULT_SPRITE = Utils.rl("backpack/shelf_status_default");
        private static final ResourceLocation SHELF_STATUS_INVALID_SPRITE = Utils.rl("backpack/shelf_status_invalid");
        private static final ResourceLocation SHELF_STATUS_VALID_SPRITE = Utils.rl("backpack/shelf_status_valid");
        private final Key key;
        private final AugmentHolder<RecallAugment> holder;
        private Status status = Status.NOT_SET;

        public ShelfStatus(int width, int height, AugmentHolder<RecallAugment> holder) {
            super(0, 0, width, height, CommonComponents.EMPTY);
            this.key = new Key(holder.backpackIndex(), holder.position());
            this.holder = holder;
        }

        private void check() {
            Optional<ShelfKey> optional = this.holder.get().shelfKey();
            optional.ifPresentOrElse(shelfKey -> {
                Network.getPlay().sendToServer((Object)new MessageCheckShelfKey(this.holder.backpackIndex(), this.holder.position()));
                PENDING.put(this.key, valid -> {
                    this.status = valid != false ? Status.VALID : Status.INVALID;
                });
            }, () -> {
                this.status = Status.NOT_SET;
            });
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.blitSprite(this.getStatusSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            int textX = this.getX() + this.getWidth() / 2;
            int textY = this.getY() + (int)Math.ceil((double)(this.getHeight() - 9) / 2.0);
            graphics.drawCenteredString(Minecraft.getInstance().font, this.getLabel(), textX, textY, -1);
        }

        private ResourceLocation getStatusSprite() {
            return switch (this.status.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SHELF_STATUS_DEFAULT_SPRITE;
                case 1 -> SHELF_STATUS_INVALID_SPRITE;
                case 2 -> SHELF_STATUS_VALID_SPRITE;
            };
        }

        private Component getLabel() {
            if (PENDING.containsKey(this.key)) {
                return CHECKING_STATUS_LABEL;
            }
            return switch (this.status.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NOT_SET_LABEL;
                case 1 -> NO_SHELF_LABEL;
                case 2 -> this.holder.get().shelfKey().map(k -> BlockPos.of((long)k.position()).toShortString()).map(Component::literal).map(c -> c).orElse(NOT_SET_LABEL);
            };
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
        }

        public static void handle(int backpackIndex, Augments.Position position, boolean valid) {
            Key key = new Key(backpackIndex, position);
            Consumer<Boolean> consumer = PENDING.remove(key);
            if (consumer != null) {
                consumer.accept(valid);
            }
        }

        private static enum Status {
            NOT_SET,
            INVALID,
            VALID;

        }

        private record Key(int backpackIndex, Augments.Position position) {
        }
    }
}

