/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomEditBox;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ItemGrid;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.impl.SeedflowAugment;
import com.mrcrayfish.backpacked.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class SeedflowMenu
extends AugmentSettingsMenu {
    private static final Component OPTIONS_LABEL = Component.translatable((String)"backpacked.gui.options");
    private static final Component SEARCH_HINT = Component.translatable((String)"backpacked.gui.search_hint");
    private static final Component RANDOMISE_SEEDS_LABEL = Component.translatable((String)"augment.backpacked.seedflow.randomize_seeds");
    private static final Component RANDOMISE_SEEDS_TOOLTIP = Component.translatable((String)"augment.backpacked.seedflow.randomize_seeds.tooltip");
    private static final Component USE_FILTERS_LABEL = Component.translatable((String)"augment.backpacked.seedflow.use_filters");
    private static final Component USE_FILTERS_TOOLTIP = Component.translatable((String)"augment.backpacked.seedflow.use_filters.tooltip");
    private static final int MIN_CONTENT_WIDTH = 162;
    private static String lastQuery = "";

    public SeedflowMenu(PopupMenuHandler handler, AugmentHolder<SeedflowAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            LinearLayout layout = LinearLayout.vertical().spacing(2);
            TitleWidget optionsTitle = (TitleWidget)layout.addChild((LayoutElement)new TitleWidget(OPTIONS_LABEL, Minecraft.getInstance().font));
            Divider divider1 = (Divider)layout.addChild((LayoutElement)Divider.horizontal(Math.max(162, optionsTitle.getWidth())).colour(-2044489));
            optionsTitle.setWidth(divider1.getWidth());
            CustomButton randomizeBtn = CustomButton.state(() -> ((SeedflowAugment)holder.get()).randomizeSeeds(), newValue -> holder.update(((SeedflowAugment)holder.get()).setRandomizeSeeds((boolean)newValue))).setMessage(() -> CommonComponents.optionStatus((boolean)((SeedflowAugment)holder.get()).randomizeSeeds())).setSize(60, 18).build();
            layout.addChild((LayoutElement)SeedflowMenu.createOption(RANDOMISE_SEEDS_LABEL, RANDOMISE_SEEDS_TOOLTIP, (AbstractWidget)randomizeBtn, divider1.getWidth()));
            CustomButton useFiltersBtn = CustomButton.state(() -> ((SeedflowAugment)holder.get()).useFilters(), newValue -> holder.update(((SeedflowAugment)holder.get()).setUseFilters((boolean)newValue))).setMessage(() -> CommonComponents.optionStatus((boolean)((SeedflowAugment)holder.get()).useFilters())).setSize(60, 18).build();
            layout.addChild((LayoutElement)SeedflowMenu.createOption(USE_FILTERS_LABEL, USE_FILTERS_TOOLTIP, (AbstractWidget)useFiltersBtn, divider1.getWidth()));
            layout.addChild((LayoutElement)Divider.horizontal(162).colour(-2044489));
            ItemGrid<SeedflowAugment> list = ItemGrid.builder(holder::get, holder::update).setWidth(divider1.getWidth()).setHeight(64).setInitialQuery(lastQuery).setPredicate(SeedflowAugment.ITEM_PLACES_AGEABLE_CROP).build();
            list.setActive(() -> ((SeedflowAugment)holder.get()).useFilters());
            layout.addChild((LayoutElement)CustomEditBox.builder().setSize(divider1.getWidth(), 16).setIcon(Utils.rl("backpack/editbox/search")).setText(lastQuery).setHint(SEARCH_HINT).setActive(() -> ((SeedflowAugment)holder.get()).useFilters()).setCallback(s -> {
                list.setSearchQuery((String)s);
                lastQuery = s;
            }).setBackground(new WidgetSprites(Utils.rl("backpack/editbox/background"), Utils.rl("backpack/editbox/background_disabled"), Utils.rl("backpack/editbox/background_focused"))).build());
            layout.addChild(list);
            return layout;
        });
    }
}

