/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.gui.ExperienceCostTooltip;
import com.mrcrayfish.backpacked.client.gui.ItemCostTooltip;
import com.mrcrayfish.backpacked.client.gui.particle.Particle2D;
import com.mrcrayfish.backpacked.client.gui.particle.ScreenParticles;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.CustomContainerScreen;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUnlockSlot;
import com.mrcrayfish.backpacked.platform.ClientServices;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public abstract class UnlockableContainerScreen<T extends AbstractContainerMenu>
extends CustomContainerScreen<T> {
    private static final Component HOLD_TO_UNLOCK = Component.translatable((String)"backpacked.gui.hold_to_unlock");
    private static final ResourceLocation ICON_LOCK = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/lock");
    private static final ResourceLocation ICON_LOCK_OUTLINED = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/lock_outlined");
    private static final ResourceLocation EXP_ORB = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/exp_orb");
    private static final int UNLOCK_TIME = 20;
    private final ScreenParticles screenParticles = new ScreenParticles();
    private final RandomSource random = RandomSource.create();
    private final Player player;
    protected final Set<UnlockableSlot> selectedSlots = new LinkedHashSet<UnlockableSlot>();
    @Nullable
    private UnlockableSlot lastAddedUnlockableSlot;
    @Nullable
    private UnlockableSlot hoveredLockedSlot;
    private int heldUnlockTime;
    private int totalUnlockTime;
    protected boolean hideLockedSlots;

    public UnlockableContainerScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.player = inventory.player;
    }

    public void setHideLockedSlots(boolean hideLockedSlots) {
        this.hideLockedSlots = hideLockedSlots;
    }

    protected void containerTick() {
        this.screenParticles.tickParticles();
        if (!this.selectedSlots.isEmpty()) {
            if (this.hoveredLockedSlot == null) {
                this.selectedSlots.clear();
                this.lastAddedUnlockableSlot = null;
                return;
            }
            if (this.heldUnlockTime-- <= 0) {
                List<Integer> slotIndexes = this.selectedSlots.stream().map(slot -> slot.index).toList();
                Network.PLAY.sendToServer((Object)new MessageUnlockSlot(slotIndexes));
                this.selectedSlots.clear();
                this.lastAddedUnlockableSlot = null;
            } else if (this.heldUnlockTime % 2 == 0) {
                float pitch = 0.7f + 0.6f * (float)(this.totalUnlockTime - this.heldUnlockTime) / (float)Math.max(1, this.totalUnlockTime);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)pitch, (float)0.25f));
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoveredLockedSlot = null;
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.screenParticles.renderParticles(graphics, partialTicks);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        if (!this.selectedSlots.isEmpty()) {
            int progressWidth = (int)((float)(16 * (this.totalUnlockTime - this.heldUnlockTime)) / (float)Math.max(1, this.totalUnlockTime));
            for (UnlockableSlot slot : this.selectedSlots) {
                int progressX = this.leftPos + slot.x;
                int progressY = this.topPos + slot.y;
                graphics.fill(progressX, progressY, progressX + progressWidth, progressY + 16, -2002256052);
            }
        }
        for (Slot slot : this.getMenu().slots) {
            if (!(slot instanceof UnlockableSlot)) continue;
            UnlockableSlot lockedSlot = (UnlockableSlot)slot;
            if (this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
                this.hoveredLockedSlot = lockedSlot;
            }
            if (lockedSlot.isUnlocked()) continue;
            if (this.selectedSlots.contains(slot)) {
                graphics.blitSprite(ICON_LOCK_OUTLINED, this.leftPos + slot.x + 1, this.topPos + slot.y + 1, 14, 14);
                continue;
            }
            graphics.blitSprite(ICON_LOCK, this.leftPos + slot.x + 2, this.topPos + slot.y + 2, 12, 12);
            if (this.hoveredLockedSlot != lockedSlot || this.hideLockedSlots) {
                graphics.fill(this.leftPos + slot.x, this.topPos + slot.y, this.leftPos + slot.x + 16, this.topPos + slot.y + 16, -2002216310);
            }
            if (!this.hideLockedSlots) continue;
            graphics.fill(this.leftPos + slot.x - 1, this.topPos + slot.y - 1, this.leftPos + slot.x + 17, this.topPos + slot.y + 17, -1427121212);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!(this.hoveredLockedSlot == null || this.hoveredLockedSlot.isUnlocked() || !this.menu.getCarried().isEmpty() || this.hideLockedSlots && this.selectedSlots.isEmpty())) {
            List<ClientTooltipComponent> components = this.createUnlockTooltip(this.hoveredLockedSlot);
            ClientServices.CLIENT.drawTooltip(graphics, this.font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
            return;
        }
        super.renderTooltip(graphics, mouseX, mouseY);
    }

    private List<ClientTooltipComponent> createUnlockTooltip(UnlockableSlot slot) {
        Component hintText = HOLD_TO_UNLOCK;
        int nextCost = slot.getNextUnlockCost(Math.max(1, this.selectedSlots.size()));
        boolean canAfford = slot.canAffordToUnlock(this.player, Math.max(1, this.selectedSlots.size()));
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        switch (slot.getController().getCostModel().getPaymentType()) {
            case EXPERIENCE: {
                if (!canAfford) {
                    hintText = Component.translatable((String)"backpacked.gui.not_enough_exp").withStyle(ChatFormatting.RED);
                }
                components.add(new ExperienceCostTooltip(nextCost));
                components.add((ClientTooltipComponent)new ClientTextTooltip(hintText.getVisualOrderText()));
                break;
            }
            case ITEM: {
                if (!canAfford) {
                    hintText = Component.translatable((String)"backpacked.gui.missing_items").withStyle(ChatFormatting.RED);
                }
                components.add(new ItemCostTooltip(slot.getController().getPaymentItem(), nextCost));
                components.add((ClientTooltipComponent)new ClientTextTooltip(hintText.getVisualOrderText()));
            }
        }
        return components;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.hasPopupMenu() && button == 0 && this.hoveredLockedSlot != null && !this.hoveredLockedSlot.isUnlocked() && this.menu.getCarried().isEmpty() && !this.hideLockedSlots && this.hoveredLockedSlot.canAffordToUnlock(this.player, 1)) {
            this.addSlotToSelected(this.hoveredLockedSlot);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.hasPopupMenu() && button == 0 && this.lastAddedUnlockableSlot != null && this.hoveredLockedSlot != null && this.lastAddedUnlockableSlot != this.hoveredLockedSlot && !this.hoveredLockedSlot.isUnlocked() && !this.selectedSlots.contains((Object)this.hoveredLockedSlot) && this.hoveredLockedSlot.canAffordToUnlock(this.player, this.selectedSlots.size() + 1)) {
            this.addSlotToSelected(this.hoveredLockedSlot);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void addSlotToSelected(UnlockableSlot slot) {
        this.selectedSlots.add(slot);
        this.lastAddedUnlockableSlot = slot;
        this.heldUnlockTime = this.totalUnlockTime = Mth.clamp((int)(20 + 4 * (this.selectedSlots.size() - 1)), (int)20, (int)80);
        float pitch = 0.6f + 0.4f * this.random.nextFloat();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.COPPER_HIT, (float)pitch, (float)0.6f));
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.selectedSlots.isEmpty()) {
            this.selectedSlots.clear();
            this.lastAddedUnlockableSlot = null;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onSlotUnlocked(List<Integer> slotIndexes) {
        boolean playSound = false;
        for (int slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= this.menu.slots.size()) continue;
            Slot slot = this.menu.getSlot(slotIndex);
            if (!(slot instanceof UnlockableSlot)) {
                return;
            }
            int slotX = this.leftPos + slot.x;
            int slotY = this.topPos + slot.y;
            this.spawnSlotUnlockedParticles(slotX, slotY);
            playSound = true;
        }
        if (playSound) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.PLAYER_LEVELUP, (float)1.3f, (float)0.25f));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_BREAK, (float)1.3f, (float)0.7f));
        }
    }

    private void spawnSlotUnlockedParticles(int slotX, int slotY) {
        int i;
        Particle2D top = new Particle2D(slotX + 2, slotY + 2, 12.0, 6.0).setLife(50).setSprite(0.0f, 0.0f, 1.0f, 0.5f, ICON_LOCK).setMotion(new Vector2d((double)this.random.nextIntBetweenInclusive(-20, 20), -100.0)).setRotationSpeed(this.random.nextIntBetweenInclusive(-180, 180)).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.025).setStartScale(1.0f, 40).setEndScale(0.0f);
        this.screenParticles.addParticle(top);
        Particle2D bottom = new Particle2D(slotX + 2, slotY + 8, 12.0, 6.0).setLife(50).setSprite(0.0f, 0.5f, 1.0f, 1.0f, ICON_LOCK).setMotion(new Vector2d((double)this.random.nextIntBetweenInclusive(-20, 20), 50.0)).setRotationSpeed(this.random.nextIntBetweenInclusive(-180, 180)).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.025).setStartScale(1.0f, 40).setEndScale(0.0f);
        this.screenParticles.addParticle(bottom);
        for (i = 0; i < 10; ++i) {
            Particle2D damageParticle = new Particle2D(slotX + 7, slotY + 7, 2.0, 2.0).setLife(20).setSprite(0.45f, 0.5f, 0.55f, 0.6f, ICON_LOCK).setMotion(new Vector2d((double)Mth.cos((float)((float)Math.PI * 2 * this.random.nextFloat())), (double)Mth.sin((float)((float)Math.PI * 2 * this.random.nextFloat()))).mul((double)this.random.nextIntBetweenInclusive(50, 100))).setRotationSpeed(180.0).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.05).setStartScale(1.0f).setEndScale(0.0f);
            this.screenParticles.addParticle(damageParticle);
        }
        if (((Boolean)Config.CLIENT.glitterBomb.get()).booleanValue()) {
            for (i = 0; i < 200; ++i) {
                Particle2D expOrbParticle = new Particle2D(slotX + 6, slotY + 6, 4.0, 4.0).setLife(50).setSprite(0.0f, 0.0f, 1.0f, 1.0f, EXP_ORB).setMotion(new Vector2d((double)Mth.cos((float)((float)Math.PI * 2 * this.random.nextFloat())), (double)Mth.sin((float)((float)Math.PI * 2 * this.random.nextFloat()))).mul((double)this.random.nextIntBetweenInclusive(1, 500))).setRotationSpeed(180.0).setGravity(new Vector2d(0.0, 20.0)).setFriction(0.05).setStartScale(1.0f).setEndScale(0.0f);
                this.screenParticles.addParticle(expOrbParticle);
            }
        }
    }
}

