/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.client.gui.StateSprites;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class CustomSelectionList<E extends ObjectSelectionList.Entry<E>>
extends ObjectSelectionList<E> {
    private static final int OUTLINE_SIZE = 1;
    private static final int SCROLL_BAR_GAP = 2;
    protected int contentPadding = 2;
    protected int scrollBarWidth = 6;
    protected int itemSpacing = 2;
    protected boolean scrolling;
    protected boolean scrollBarAlwaysVisible;
    @Nullable
    protected ResourceLocation listBackground;
    @Nullable
    protected StateSprites itemSprites;
    @Nullable
    protected StateSprites scrollBarSprites;
    @Nullable
    protected ResourceLocation scrollBarBackground;
    protected ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
    @Nullable
    protected Supplier<Boolean> activeSupplier;

    public CustomSelectionList(int width, int height, int x, int y, int itemHeight) {
        super(Minecraft.getInstance(), width, height, y, itemHeight);
        this.setPosition(x, y);
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.setSize(this.width, this.height);
    }

    public void setContentPadding(int contentPadding) {
        this.contentPadding = contentPadding;
    }

    public void setScrollBarWidth(int scrollBarWidth) {
        this.scrollBarWidth = scrollBarWidth;
    }

    public void setItemSpacing(int itemSpacing) {
        this.itemSpacing = itemSpacing;
    }

    public void setListBackground(@Nullable ResourceLocation background) {
        this.listBackground = background;
    }

    public void setItemSprites(@Nullable StateSprites sprites) {
        this.itemSprites = sprites;
    }

    public void setScrollBarSprites(@Nullable StateSprites sprites) {
        this.scrollBarSprites = sprites;
    }

    public void setScrollBarBackground(@Nullable ResourceLocation background) {
        this.scrollBarBackground = background;
    }

    public void setScrollBarStyle(ScrollBarStyle scrollBarStyle) {
        this.scrollBarStyle = scrollBarStyle;
    }

    public void setScrollBarAlwaysVisible(boolean scrollBarAlwaysVisible) {
        this.scrollBarAlwaysVisible = scrollBarAlwaysVisible;
    }

    public void setActive(@Nullable Supplier<Boolean> activeSupplier) {
        this.activeSupplier = activeSupplier;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight()) && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth());
    }

    public int getRowWidth() {
        return this.getRowRight() - this.getRowLeft();
    }

    public int getRowLeft() {
        return this.getX() + 1 + this.contentPadding;
    }

    public int getRowRight() {
        if (this.getMaxScroll() > 0 || this.scrollBarAlwaysVisible) {
            int scrollBarArea = switch (this.scrollBarStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.contentPadding + 1 + 2 + 1 + this.contentPadding + this.scrollBarWidth + this.contentPadding + 1;
                case 1 -> this.contentPadding + this.scrollBarWidth + this.contentPadding + 1;
            };
            return this.getX() + this.getWidth() - scrollBarArea;
        }
        return this.getX() + this.getWidth() - this.contentPadding - 1;
    }

    protected int getRowTop(int index) {
        return this.getY() + 1 + this.contentPadding - (int)this.getScrollAmount() + index * this.itemHeight + index * this.itemSpacing;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - this.scrollBarWidth - this.contentPadding - 1;
    }

    private int getScrollbarHeight() {
        int scrollAreaHeight = this.getScrollAreaHeight();
        int scrollBarHeight = (int)((float)Mth.square((int)scrollAreaHeight) / (float)this.getMaxPosition());
        return Mth.clamp((int)scrollBarHeight, (int)32, (int)scrollAreaHeight);
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height;
    }

    public int getScrollAreaHeight() {
        return this.height - 2 - this.contentPadding * 2;
    }

    public int getScrollAreaTop() {
        return this.getY() + 1 + this.contentPadding;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height + this.contentPadding * 2 + 2);
    }

    protected int getMaxPosition() {
        return this.getItemCount() * (this.itemHeight + this.itemSpacing) - this.itemSpacing;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            this.active = this.activeSupplier.get();
        }
        if (this.listBackground != null) {
            int backgroundWidth = switch (this.scrollBarStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 1 + this.contentPadding + this.getRowWidth() + this.contentPadding + 1;
                case 1 -> this.getWidth();
            };
            graphics.blitSprite(this.listBackground, this.getX(), this.getY(), backgroundWidth, this.getHeight());
        }
        graphics.enableScissor(this.getRowLeft() - 1, this.getY() + 1, this.getRowRight() + 1, this.getY() + this.getHeight() - 1);
        this.renderListItems(graphics, mouseX, mouseY, partialTick);
        graphics.disableScissor();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0 || this.scrollBarAlwaysVisible) {
            if (this.scrollBarStyle == ScrollBarStyle.DETACHED && this.listBackground != null) {
                graphics.blitSprite(this.listBackground, this.getScrollbarPosition() - this.contentPadding - 1, this.getY(), 1 + this.contentPadding + this.scrollBarWidth + this.contentPadding + 1, this.getHeight());
            }
            int scrollBarStart = this.getScrollbarPosition();
            int scrollBarEnd = scrollBarStart + this.scrollBarWidth;
            int scrollBarHeight = this.getScrollbarHeight();
            int scrollBarTop = (int)((double)this.getScrollAreaTop() + (double)(this.getScrollAreaHeight() - this.getScrollbarHeight()) * (this.getScrollAmount() / (double)Math.max(maxScroll, 1)));
            boolean scrollBarHovered = ScreenUtil.isPointInArea(mouseX, mouseY, scrollBarStart, scrollBarTop, this.scrollBarWidth, scrollBarHeight);
            if (this.scrollBarSprites != null) {
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                graphics.setColor(1.0f, 1.0f, 1.0f, this.active ? 1.0f : 0.5f);
                graphics.blitSprite(this.scrollBarSprites.get(false, (scrollBarHovered || this.scrolling) && maxScroll > 0), scrollBarStart, scrollBarTop, scrollBarEnd - scrollBarStart, scrollBarHeight);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            } else {
                int scrollBarColour = scrollBarHovered ? -13423059 : -12107714;
                graphics.fill(scrollBarStart, scrollBarTop, scrollBarEnd, scrollBarTop + scrollBarHeight, scrollBarColour);
            }
        }
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int startIndex;
        int rowTop;
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int rowHeight = this.itemHeight;
        int rowCount = this.getItemCount();
        for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.contentPadding) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
            this.renderItemBackground(graphics, i, rowLeft, rowTop, rowWidth, rowHeight, mouseX, mouseY);
            this.renderItem(graphics, mouseX, mouseY, partialTick, i, rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    private void renderItemBackground(GuiGraphics graphics, int index, int rowLeft, int rowTop, int rowWidth, int rowHeight, int mouseX, int mouseY) {
        if (this.itemSprites != null) {
            boolean selected = this.isSelectedItem(index);
            boolean hovered = !this.scrolling && ScreenUtil.isPointInArea(mouseX, mouseY, rowLeft, rowTop, rowWidth, rowHeight);
            graphics.blitSprite(this.itemSprites.get(selected, hovered), rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    protected void renderSelection(GuiGraphics graphics, int top, int rowWidth, int rowHeight, int outlineColour, int innerColour) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.active && super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.getFocused() != null && this.isDragging() && ((ObjectSelectionList.Entry)this.getFocused()).mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            if (this.scrolling) {
                double unitsPerScroll = (double)this.getMaxScroll() / (double)Math.max(1, this.getScrollAreaHeight() - this.getScrollbarHeight());
                this.setScrollAmount(this.getScrollAmount() + deltaY * unitsPerScroll);
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.active && super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public E getEntry(double mouseX, double mouseY) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            int startIndex;
            int rowTop;
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getRowWidth();
            int rowHeight = this.itemHeight;
            int rowCount = this.getItemCount();
            for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.contentPadding) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
                if (!ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, rowLeft, rowTop, rowWidth, rowHeight)) continue;
                return (E)((ObjectSelectionList.Entry)this.getEntry(i));
            }
        }
        return null;
    }

    public boolean updateScroll(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.getScrollbarPosition(), this.getScrollAreaTop(), this.scrollBarWidth, this.getScrollAreaHeight());
        return this.scrolling;
    }

    public static enum ScrollBarStyle {
        DETACHED,
        MERGED;

    }
}

