/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.client.gui.StateSprites;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomSelectionList;
import com.mrcrayfish.backpacked.common.FilterableItems;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public final class ItemGrid<T extends FilterableItems<T>>
extends CustomSelectionList<Row<T>> {
    private static final ResourceLocation LIST_BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/background");
    private static final StateSprites ITEM_SPRITES = new StateSprites(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/item"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/item_hovered"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/item_selected"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/item_selected"));
    private static final StateSprites SCROLL_BAR_SPRITES = new StateSprites(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/scroll_bar"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/scroll_bar_hovered"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list/scroll_bar_selected"));
    private final Supplier<T> supplier;
    private final Consumer<T> updater;
    private final int itemSize;
    private final int spacing;
    private final List<Item> items;
    private String searchQuery;
    private boolean selectedOnly;
    @Nullable
    private ItemStack hoveredStack;

    private ItemGrid(Supplier<T> supplier, Consumer<T> updater, int width, int height, int itemSize, int spacing, String lastQuery, Predicate<Item> predicate) {
        super(width, height, 0, 0, itemSize);
        this.supplier = supplier;
        this.updater = updater;
        this.itemSize = itemSize;
        this.spacing = spacing;
        this.items = (List)BuiltInRegistries.ITEM.stream().filter(predicate).collect(ImmutableList.toImmutableList());
        this.setRenderHeader(false, 0);
        this.setListBackground(LIST_BACKGROUND_SPRITE);
        this.setScrollBarSprites(SCROLL_BAR_SPRITES);
        this.setContentPadding(spacing);
        this.setItemSpacing(spacing);
        this.setScrollBarWidth(10);
        this.setScrollBarStyle(CustomSelectionList.ScrollBarStyle.DETACHED);
        this.setScrollBarAlwaysVisible(true);
        this.searchQuery = lastQuery;
        this.updateList();
    }

    private void updateList() {
        String search = this.searchQuery.toLowerCase().trim();
        boolean empty = search.trim().isBlank();
        this.clearEntries();
        ArrayList<Item> visibleItems = new ArrayList<Item>();
        this.items.forEach(item -> {
            if (item == Items.AIR) {
                return;
            }
            if ((!this.selectedOnly || ((FilterableItems)this.supplier.get()).isFilteringItem((Item)item)) && (empty || item.getDescription().getString().toLowerCase(Locale.ROOT).contains(search))) {
                visibleItems.add((Item)item);
            }
        });
        if (!empty) {
            visibleItems.sort(Comparator.comparingInt(item -> {
                String name = item.getDescription().getString().toLowerCase(Locale.ROOT);
                if (name.equals(search)) {
                    return 0;
                }
                if (name.startsWith(search)) {
                    return 1;
                }
                return 2;
            }).thenComparing(item -> item.getDescription().getString()));
        } else {
            visibleItems.sort(Comparator.comparing(item -> item.getDescription().getString()));
        }
        int chunkSize = (this.getRowWidth() + this.spacing) / (this.itemSize + this.spacing);
        for (int i = 0; i < Mth.positiveCeilDiv((int)visibleItems.size(), (int)chunkSize); ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, visibleItems.size());
            this.addEntry((AbstractSelectionList.Entry)new Row<T>(this, visibleItems.subList(start, end), this.supplier, this.updater));
        }
    }

    public void setSelectedOnly(boolean selectedOnly) {
        this.selectedOnly = selectedOnly;
        this.updateList();
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredStack = null;
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.hoveredStack != null) {
            graphics.renderTooltip(Minecraft.getInstance().font, this.hoveredStack, mouseX, mouseY);
        }
    }

    public void setSelected(@Nullable Row row) {
    }

    public void setSearchQuery(String searchQuery) {
        if (!this.searchQuery.equals(searchQuery)) {
            this.setClampedScrollAmount(0.0);
            this.searchQuery = searchQuery;
            this.updateList();
        }
    }

    public static <T extends FilterableItems<T>> Builder<T> builder(Supplier<T> supplier, Consumer<T> updater) {
        return new Builder<T>(supplier, updater);
    }

    protected static final class Row<R extends FilterableItems<R>>
    extends ObjectSelectionList.Entry<Row<R>> {
        private final ItemGrid<R> parent;
        private final List<ItemStack> display;
        private final Supplier<R> supplier;
        private final Consumer<R> updater;
        private int top;
        private int left;

        private Row(ItemGrid<R> parent, List<Item> items, Supplier<R> augment, Consumer<R> updater) {
            this.parent = parent;
            this.display = (List)items.stream().map(ItemStack::new).collect(ImmutableList.toImmutableList());
            this.supplier = augment;
            this.updater = updater;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.top = top;
            this.left = left;
            int itemSize = this.parent.itemSize;
            int spacing = this.parent.spacing;
            int halfSpacing = spacing / 2;
            boolean active = this.parent.isActive();
            for (int i = 0; i < this.display.size(); ++i) {
                ItemStack stack = this.display.get(i);
                int offset = i * (itemSize + spacing);
                boolean itemSelected = ((FilterableItems)this.supplier.get()).isFilteringItem(stack.getItem());
                boolean itemHovered = active && ScreenUtil.isPointInArea(mouseX, mouseY, left + offset - halfSpacing, top - halfSpacing, itemSize + spacing, itemSize + spacing);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                graphics.setColor(1.0f, 1.0f, 1.0f, active ? 1.0f : 0.5f);
                graphics.blitSprite(ITEM_SPRITES.get(itemSelected, itemHovered), left + offset, top, itemSize, itemSize);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
                graphics.renderFakeItem(stack, left + offset + (itemSize - 16) / 2, top + (itemSize - 16) / 2);
                if (!itemHovered) continue;
                this.parent.hoveredStack = stack;
            }
        }

        public Component getNarration() {
            return CommonComponents.EMPTY;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                int itemSize = this.parent.itemSize;
                int spacing = this.parent.spacing;
                int halfSpacing = spacing / 2;
                FilterableItems augment = (FilterableItems)this.supplier.get();
                for (int i = 0; i < this.display.size(); ++i) {
                    int offset = i * (itemSize + spacing);
                    if (!ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.left + offset - halfSpacing, this.top - halfSpacing, itemSize + spacing, itemSize + spacing)) continue;
                    ItemStack stack = this.display.get(i);
                    if (!augment.isFilteringItem(stack.getItem())) {
                        if (augment.isFilterFull()) continue;
                        this.updater.accept(augment.addItemFilter(stack.getItem()));
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                        return true;
                    }
                    this.updater.accept(augment.removeItemFilter(stack.getItem()));
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    return true;
                }
            }
            return false;
        }
    }

    public static class Builder<T extends FilterableItems<T>> {
        private final Supplier<T> supplier;
        private final Consumer<T> updater;
        private int width = 64;
        private int height = 64;
        private int itemSize = 18;
        private int spacing = 2;
        private String initialQuery = "";
        private Predicate<Item> predicate = item -> true;

        private Builder(Supplier<T> supplier, Consumer<T> updater) {
            this.supplier = supplier;
            this.updater = updater;
        }

        public Builder<T> setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> setItemSize(int itemSize) {
            this.itemSize = itemSize;
            return this;
        }

        public Builder<T> setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder<T> setInitialQuery(String initialQuery) {
            this.initialQuery = initialQuery;
            return this;
        }

        public Builder<T> setPredicate(Predicate<Item> predicate) {
            this.predicate = predicate;
            return this;
        }

        public ItemGrid<T> build() {
            return new ItemGrid<T>(this.supplier, this.updater, this.width, this.height, this.itemSize, this.spacing, this.initialQuery, this.predicate);
        }
    }
}

