/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class TitleWidget
extends AbstractWidget {
    private static final ResourceLocation CHECKERS = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/checkers");
    private final Supplier<FormattedCharSequence> display;
    private final Font font;
    private int shift;

    public TitleWidget(FormattedCharSequence text, Component narration, Font font) {
        int n = font.width(text);
        Objects.requireNonNull(font);
        super(0, 0, n, 9, narration);
        this.display = () -> text;
        this.font = font;
    }

    public TitleWidget(Component text, Font font) {
        int n = font.width(text.getVisualOrderText());
        Objects.requireNonNull(font);
        super(0, 0, n, 9, text);
        this.display = () -> ((Component)text).getVisualOrderText();
        this.font = font;
    }

    public TitleWidget(Supplier<Component> text, Font font) {
        int n = font.width(text.get().getVisualOrderText());
        Objects.requireNonNull(font);
        super(0, 0, n, 9, text.get());
        this.display = () -> ((Component)text.get()).getVisualOrderText();
        this.font = font;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        FormattedCharSequence displayText = this.display.get();
        int titleWidth = this.font.width(displayText);
        int titleX = this.getX() + (this.getWidth() - titleWidth) / 2 + this.shift;
        if (this.getWidth() > titleWidth) {
            int n = this.getX();
            int n2 = this.getY();
            int n3 = titleX - this.getX() - 3;
            Objects.requireNonNull(this.font);
            graphics.blitSprite(CHECKERS, n, n2, n3, 9);
            int n4 = this.getY();
            int n5 = this.getRight() - titleX - titleWidth - 3;
            Objects.requireNonNull(this.font);
            graphics.blitSprite(CHECKERS, titleX + titleWidth + 3, n4, n5, 9);
        }
        graphics.drawString(this.font, displayText, titleX, this.getY() + 1, -10399683, false);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    public TitleWidget setShift(int shift) {
        this.shift = shift;
        return this;
    }
}

