/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.MenuItem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PopupItem
extends MenuItem {
    private final PopupMenu menu;

    private PopupItem(Component label, PopupMenu menu) {
        super(label);
        this.menu = menu;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        if (this.selected()) {
            poseStack.translate(0.0f, 0.0f, 51.0f);
        }
        super.renderWidget(graphics, mouseX, mouseY, deltaTick);
        Font font = Minecraft.getInstance().font;
        int n = this.getY();
        int n2 = this.getHeight();
        Objects.requireNonNull(font);
        int top = n + (n2 - 9) / 2 + 1;
        graphics.drawString(Minecraft.getInstance().font, ">", this.getX() + this.getWidth() - 10, top, -1);
        poseStack.popPose();
    }

    public void onClick(double mouseX, double mouseY) {
        this.menu.show(this.getRectangle());
    }

    @Override
    protected boolean selected() {
        return this.menu.hasChild();
    }

    @Override
    protected int calculateWidth() {
        Font font = Minecraft.getInstance().font;
        int n = this.getHeight();
        Objects.requireNonNull(font);
        int labelOffset = (n - 9) / 2 + 1;
        int labelWidth = font.width((FormattedText)this.getMessage());
        int arrowWidth = font.width(">");
        return labelOffset + labelWidth + labelOffset + arrowWidth + labelOffset;
    }

    public static MenuItem create(Component label, PopupMenu menu) {
        return new PopupItem(label, menu);
    }
}

