/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;

public class BakedModelRenderer {
    private static final RandomSource RANDOM = RandomSource.create();

    public static void drawBakedModel(BakedModel model, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        stack.pushPose();
        stack.translate(-0.5f, -0.5f, -0.5f);
        VertexConsumer consumer = source.getBuffer(Sheets.translucentCullBlockSheet());
        for (Direction direction : Direction.values()) {
            BakedModelRenderer.pushQuads(stack, consumer, model.getQuads(null, direction, RANDOM), light, overlay);
        }
        BakedModelRenderer.pushQuads(stack, consumer, model.getQuads(null, null, RANDOM), light, overlay);
        stack.popPose();
    }

    private static void pushQuads(PoseStack stack, VertexConsumer consumer, List<BakedQuad> quads, int light, int overlay) {
        PoseStack.Pose pose = stack.last();
        for (BakedQuad quad : quads) {
            consumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

