/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack.advanced.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.advanced.value.Value;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;

public record EntityDataValue(Data data) implements Value
{
    public static final Value.Type TYPE = new Value.Type(Utils.rl("entity_data"), (MapCodec<? extends Value>)RecordCodecBuilder.mapCodec(builder -> builder.group((App)Data.CODEC.fieldOf("property").forGetter(o -> o.data)).apply((Applicative)builder, EntityDataValue::new)));

    @Override
    public Value.Type type() {
        return TYPE;
    }

    @Override
    public double get(BackpackRenderContext context) {
        LivingEntity entity = context.entity();
        if (entity == null) {
            return 0.0;
        }
        return this.data.function.apply(entity, context);
    }

    private static enum Data implements StringRepresentable
    {
        WALK_POSITION("walk_position", (entity, context) -> entity.walkAnimation.position(context.partialTick())),
        WALK_SPEED("walk_speed", (entity, context) -> entity.walkAnimation.speed(context.partialTick())),
        HEAD_YAW("head_yaw", (entity, context) -> entity.getViewXRot(context.partialTick())),
        HEAD_PITCH("head_pitch", (entity, context) -> entity.getViewYRot(context.partialTick())),
        BODY_ROTATION("body_rotation", (entity, context) -> Mth.rotLerp((float)context.partialTick(), (float)entity.yBodyRotO, (float)entity.yBodyRot)),
        SWIM_ANGLE("swimming", (entity, context) -> entity.getSwimAmount(context.partialTick())),
        ATTACK_SWING("attack_swing", (entity, context) -> entity.getAttackAnim(context.partialTick())),
        FALL_FLYING_COUNTER("fall_flying_counter", (entity, context) -> entity.isFallFlying() ? (double)entity.getFallFlyingTicks() + (double)context.partialTick() : 0.0),
        HEALTH("health", (entity, context) -> entity.getHealth()),
        MAX_HEALTH("max_health", (entity, context) -> entity.getMaxHealth()),
        ABSORPTION("absorption", (entity, context) -> entity.getAbsorptionAmount()),
        MAX_ABSORPTION("max_absorption", (entity, context) -> entity.getMaxAbsorption()),
        ARMOR("armor", (entity, context) -> entity.getArmorValue()),
        ARMOR_COVERAGE("armor_coverage", (entity, context) -> entity.getArmorCoverPercentage()),
        AIR_SUPPLY("air_supply", (entity, context) -> entity.getAirSupply()),
        MAX_AIR_SUPPLY("max_air_supply", (entity, context) -> entity.getMaxAirSupply()),
        POSITION_X("pos_x", (entity, context) -> Mth.lerp((double)context.partialTick(), (double)entity.xo, (double)entity.getX())),
        POSITION_Y("pos_y", (entity, context) -> Mth.lerp((double)context.partialTick(), (double)entity.yo, (double)entity.getY())),
        POSITION_Z("pos_z", (entity, context) -> Mth.lerp((double)context.partialTick(), (double)entity.zo, (double)entity.getZ())),
        MOTION_X("motion_x", (entity, context) -> entity.getDeltaMovement().x),
        MOTION_Y("motion_y", (entity, context) -> entity.getDeltaMovement().y),
        MOTION_Z("motion_z", (entity, context) -> entity.getDeltaMovement().z),
        LIGHT_LEVEL("light_level", (entity, context) -> entity.level().getLightEngine().getRawBrightness(entity.blockPosition(), 0));

        public static final Codec<Data> CODEC;
        private final String name;
        private final BiFunction<LivingEntity, BackpackRenderContext, Double> function;

        private Data(String name, BiFunction<LivingEntity, BackpackRenderContext, Double> function) {
            this.name = name;
            this.function = function;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Data::values);
        }
    }
}

