/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record ItemCollection(HashSet<ResourceLocation> ids) {
    public static final ItemCollection EMPTY = new ItemCollection(new HashSet<ResourceLocation>());
    public static final int MAX_ENTRIES = 256;
    public static final Codec<ItemCollection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.sizeLimitedListOf(256).xmap(HashSet::new, ArrayList::new).fieldOf("ids").orElse(new HashSet()).forGetter(f -> f.ids)).apply((Applicative)instance, ItemCollection::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemCollection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), ItemCollection::ids, ItemCollection::new);
    private static final ResourceLocation AIR = ResourceLocation.withDefaultNamespace((String)"air");

    public ItemCollection {
        ids.removeIf(id -> !BuiltInRegistries.ITEM.containsKey(id) || id.equals((Object)AIR));
        if (ids.size() > 256) {
            Iterator<ResourceLocation> it = ids.iterator();
            while (ids.size() > 256 && it.hasNext()) {
                it.remove();
            }
        }
    }

    public boolean has(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return this.ids.contains(id);
    }

    public ItemCollection add(Item item) {
        if (this.ids.size() >= 256) {
            return this;
        }
        HashSet<ResourceLocation> filters = new HashSet<ResourceLocation>(this.ids);
        filters.add(BuiltInRegistries.ITEM.getKey((Object)item));
        return new ItemCollection(filters);
    }

    public ItemCollection remove(Item item) {
        HashSet<ResourceLocation> filters = new HashSet<ResourceLocation>(this.ids);
        filters.remove(BuiltInRegistries.ITEM.getKey((Object)item));
        return new ItemCollection(filters);
    }

    public ItemCollection filter(Predicate<Item> predicate) {
        HashSet<ResourceLocation> filters = new HashSet<ResourceLocation>(this.ids);
        filters.removeIf(id -> !predicate.test((Item)BuiltInRegistries.ITEM.get(id)));
        return new ItemCollection(filters);
    }

    public ItemCollection limit(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be greater than zero");
        if (this.ids.size() <= size) {
            return this;
        }
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>(this.ids);
        Iterator<ResourceLocation> it = set.iterator();
        while (set.size() > size && it.hasNext()) {
            it.remove();
        }
        return new ItemCollection(set);
    }
}

