/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.serialization.Codec;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.core.ModRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public interface Augment<T extends Augment<T>> {
    public static final Codec<Augment<?>> CODEC = AugmentType.CODEC.dispatch(Augment::type, AugmentType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Augment<?>> STREAM_CODEC = StreamCodec.of((buf, augment) -> {
        ResourceLocation.STREAM_CODEC.encode(buf, (Object)augment.type().id());
        augment.type().streamCodec().encode(buf, augment);
    }, buf -> {
        ResourceLocation id = buf.readResourceLocation();
        AugmentType type = (AugmentType)ModRegistries.AUGMENT_TYPES.getValue(id);
        if (type == null) {
            throw new IllegalStateException("Unknown augment type " + String.valueOf(id));
        }
        return (Augment)type.streamCodec().decode(buf);
    });

    public AugmentType<T> type();

    default public T onUpdate(ServerPlayer player, Augment<?> current) {
        return (T)this;
    }
}

