/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record SavedAugments(Map<AugmentType<?>, Augment<?>> map) {
    public static final Codec<SavedAugments> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(AugmentType.CODEC, Augment.CODEC).optionalFieldOf("map", new HashMap()).forGetter(SavedAugments::map)).apply((Applicative)instance, map -> new SavedAugments((Map<AugmentType<?>, Augment<?>>)ImmutableMap.copyOf((Map)map))));
    public static final StreamCodec<RegistryFriendlyByteBuf, SavedAugments> STREAM_CODEC = StreamCodec.composite((StreamCodec)Augment.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), a -> Collections.unmodifiableCollection(a.map().values()), SavedAugments::new);

    public SavedAugments() {
        this((Map<AugmentType<?>, Augment<?>>)ImmutableMap.of());
    }

    public SavedAugments(Collection<Augment<?>> list) {
        this((Map<AugmentType<?>, Augment<?>>)SavedAugments.collectionToMap(list));
    }

    public SavedAugments add(Augment<?> augment) {
        Augment<?> current = this.map.get(augment.type());
        if (augment.equals(current)) {
            return this;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.map);
        builder.put(augment.type(), augment);
        return new SavedAugments((Map<AugmentType<?>, Augment<?>>)builder.buildKeepingLast());
    }

    public SavedAugments remove(Augment<?> augment) {
        Augment<?> current = this.map.get(augment.type());
        if (current == null) {
            return this;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<AugmentType<?>, Augment<?>> entry : this.map.entrySet()) {
            if (entry.getKey().equals(current.type())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return new SavedAugments((Map<AugmentType<?>, Augment<?>>)builder.buildKeepingLast());
    }

    public Augment<?> getSavedOrCreateDefault(AugmentType<?> type) {
        return this.map.getOrDefault(type, (Augment)type.defaultSupplier().get());
    }

    private static ImmutableMap<AugmentType<?>, Augment<?>> collectionToMap(Collection<Augment<?>> augments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        augments.forEach(augment -> builder.put(augment.type(), augment));
        return builder.buildKeepingLast();
    }

    public static SavedAugments get(ItemStack stack) {
        return (SavedAugments)stack.getOrDefault((DataComponentType)ModDataComponents.SAVED_AUGMENTS.get(), (Object)new SavedAugments());
    }

    public static void set(ItemStack stack, SavedAugments augments) {
        stack.set((DataComponentType)ModDataComponents.SAVED_AUGMENTS.get(), (Object)augments);
    }
}

