/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModPointOfInterests;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class Recall
extends SavedData {
    public static final String ID = "backpacked_recall";
    private static final int MAX_QUEUE_SIZE = 18;
    private final ServerLevel level;
    private final Object2ObjectOpenHashMap<SectionPos, Short2ObjectOpenHashMap<ShelfQueue>> queues;
    private int timer;
    private boolean runNow;
    private boolean force;

    public static SavedData.Factory<Recall> factory(ServerLevel level) {
        return new SavedData.Factory(() -> new Recall(level), (tag, provider) -> Recall.load(level, provider, tag), null);
    }

    public Recall(ServerLevel level) {
        this.level = level;
        this.queues = new Object2ObjectOpenHashMap();
    }

    public void onShelfBroken(ShelfBlockEntity shelf) {
        this.removeAndFlushQueueToBlockPos(shelf.key());
    }

    public boolean recallToShelf(ServerPlayer player, ShelfKey key, int originalIndex, ItemStack backpack) {
        BlockPos pos = BlockPos.of((long)key.position());
        if (!this.level.isInWorldBounds(pos)) {
            return false;
        }
        if (!this.isShelfAtBlockPos(pos)) {
            return false;
        }
        ShelfQueue queue = this.getOrCreateShelfQueue(pos);
        if (!queue.add(player, originalIndex, backpack, this.timer)) {
            return false;
        }
        this.runNow = true;
        this.setDirty();
        return true;
    }

    private ShelfQueue getOrCreateShelfQueue(BlockPos pos) {
        SectionPos sectionPos = SectionPos.of((BlockPos)pos);
        short relativePos = SectionPos.sectionRelativePos((BlockPos)pos);
        Short2ObjectOpenHashMap sectionMap = (Short2ObjectOpenHashMap)this.queues.computeIfAbsent((Object)sectionPos, k -> new Short2ObjectOpenHashMap());
        return (ShelfQueue)sectionMap.computeIfAbsent(relativePos, k -> new ShelfQueue());
    }

    public boolean isShelfAtBlockPos(BlockPos pos) {
        if (!this.level.isInWorldBounds(pos)) {
            return false;
        }
        if (this.level.getPoiManager().existsAtPosition(ModPointOfInterests.BACKPACK_SHELF.key(), pos)) {
            return true;
        }
        if (!this.level.isLoaded(pos)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        if (!(state.getBlock() instanceof ShelfBlock)) {
            return false;
        }
        Optional optional = PoiTypes.forState((BlockState)state);
        if (optional.isEmpty()) {
            return false;
        }
        this.level.getPoiManager().add(pos, (Holder)optional.get());
        return true;
    }

    public void forceNextRun() {
        this.force = true;
        this.runNow = true;
    }

    public int flushAllQueues(MinecraftServer server) {
        int[] count = new int[]{0};
        ObjectIterator it = this.queues.entrySet().iterator();
        while (it.hasNext()) {
            ((Short2ObjectOpenHashMap)((Map.Entry)it.next()).getValue()).forEach((relativePos, shelfQueue) -> shelfQueue.forEach((owner, items) -> {
                count[0] = count[0] + this.flushQueue(server, (UUID)owner, (List<QueuedItem>)items);
            }));
            it.remove();
            this.setDirty();
        }
        return count[0];
    }

    private int flushQueue(MinecraftServer server, UUID owner, List<QueuedItem> items) {
        ServerPlayer player = server.getPlayerList().getPlayer(owner);
        if (player == null) {
            return 0;
        }
        int[] count = new int[]{0};
        for (QueuedItem item : items) {
            Vec3 pos = player.position();
            ItemEntity entity = new ItemEntity(player.level(), pos.x, pos.y, pos.z, item.stack.copyAndClear());
            entity.setDefaultPickUpDelay();
            entity.setExtendedLifetime();
            player.level().addFreshEntity((Entity)entity);
            count[0] = count[0] + 1;
        }
        return count[0];
    }

    private void flushItem(ServerLevel level, Vec3 position, ItemStack stack) {
        if (!stack.isEmpty()) {
            ItemEntity entity = new ItemEntity((Level)this.level, position.x, position.y, position.z, stack.copyAndClear());
            entity.setDefaultPickUpDelay();
            entity.setExtendedLifetime();
            level.addFreshEntity((Entity)entity);
        }
    }

    private void removeAndFlushQueueToBlockPos(ShelfKey key) {
        short relativePos;
        ShelfQueue queue;
        BlockPos pos = BlockPos.of((long)key.position());
        SectionPos sectionPos = SectionPos.of((BlockPos)pos);
        Short2ObjectOpenHashMap sectionMap = (Short2ObjectOpenHashMap)this.queues.get((Object)sectionPos);
        if (sectionMap != null && (queue = (ShelfQueue)sectionMap.remove(relativePos = SectionPos.sectionRelativePos((BlockPos)pos))) != null) {
            queue.forEach((owner, items) -> items.forEach(item -> {
                this.removeInvalidShelfFromItemStack(item.stack);
                this.flushItem(this.level, pos.getCenter(), item.stack);
            }));
            if (sectionMap.isEmpty()) {
                this.queues.remove((Object)sectionPos);
            }
            this.setDirty();
        }
    }

    private void removeInvalidShelfFromItemStack(ItemStack stack) {
        Augments augments = Augments.get(stack);
        RecallAugment augment = (RecallAugment)augments.findEnabledAndCast((AugmentType)ModAugmentTypes.RECALL.get());
        if (augment != null) {
            augment = augment.setShelfKey(null);
            for (Augments.Position position : Augments.Position.values()) {
                if (augments.getAugment(position).type() != ModAugmentTypes.RECALL.get()) continue;
                augments.setAugment(position, augment);
                break;
            }
            Augments.set(stack, augments);
        }
    }

    public void tick() {
        ++this.timer;
        if (!this.runNow && this.timer % 5 != 0) {
            return;
        }
        if (this.level.players().isEmpty()) {
            return;
        }
        ObjectIterator sectionIterator = this.queues.entrySet().iterator();
        while (sectionIterator.hasNext()) {
            Map.Entry sectionEntry = (Map.Entry)sectionIterator.next();
            ObjectIterator relativeIterator = ((Short2ObjectOpenHashMap)sectionEntry.getValue()).short2ObjectEntrySet().iterator();
            while (relativeIterator.hasNext()) {
                Pair<UUID, List<QueuedItem>> playerQueue;
                ShelfQueue queue;
                Short2ObjectMap.Entry relativeEntry = (Short2ObjectMap.Entry)relativeIterator.next();
                BlockPos pos = ((SectionPos)sectionEntry.getKey()).relativeToBlockPos(relativeEntry.getShortKey());
                if (!this.force && !this.level.isLoaded(pos)) continue;
                Optional shelfOptional = this.level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.SHELF.get());
                if (shelfOptional.isEmpty() || !this.isShelfAtBlockPos(pos)) {
                    queue = (ShelfQueue)relativeEntry.getValue();
                    queue.forEach((owner, items) -> items.forEach(item -> {
                        this.removeInvalidShelfFromItemStack(item.stack);
                        this.flushItem(this.level, pos.getCenter(), item.stack);
                    }));
                    sectionIterator.remove();
                    this.setDirty();
                    continue;
                }
                queue = (ShelfQueue)relativeEntry.getValue();
                ShelfBlockEntity shelf = (ShelfBlockEntity)((Object)shelfOptional.get());
                Map<UUID, List<QueuedItem>> playerToQueue = queue.queues();
                if (playerToQueue != null && shelf.getBackpack().isEmpty() && (playerQueue = Recall.getMinimumQueue(playerToQueue)) != null) {
                    QueuedItem item = (QueuedItem)((List)playerQueue.getSecond()).removeFirst();
                    shelf.recall(item.stack, (UUID)playerQueue.getFirst(), item.originalIndex);
                    queue.decrementCount();
                    queue.cleanQueues();
                    this.setDirty();
                }
                shelf.setRecallQueueCount(queue.count);
                if (!queue.isEmpty()) continue;
                relativeIterator.remove();
                this.setDirty();
            }
            if (!((Short2ObjectOpenHashMap)sectionEntry.getValue()).isEmpty()) continue;
            sectionIterator.remove();
            this.setDirty();
        }
        this.runNow = false;
        this.force = false;
    }

    @Nullable
    private static Pair<UUID, List<QueuedItem>> getMinimumQueue(Map<UUID, List<QueuedItem>> playerToQueue) {
        UUID owner = null;
        List<QueuedItem> minItems = null;
        for (Map.Entry<UUID, List<QueuedItem>> entry : playerToQueue.entrySet()) {
            List<QueuedItem> items = entry.getValue();
            if (items.isEmpty() || minItems != null && items.getFirst().time >= ((QueuedItem)minItems.getFirst()).time) continue;
            owner = entry.getKey();
            minItems = items;
        }
        return minItems != null ? Pair.of(owner, minItems) : null;
    }

    private static Recall load(ServerLevel level, HolderLookup.Provider provider, CompoundTag tag) {
        Recall recall = new Recall(level);
        recall.timer = tag.getInt("Timer");
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ListTag sectionList = tag.getList("RecallQueues", 10);
        sectionList.forEach(nbt -> {
            try {
                CompoundTag sectionTag = (CompoundTag)nbt;
                if (!sectionTag.contains("SectionPos", 4)) {
                    throw new IllegalArgumentException("Missing section position");
                }
                SectionPos sectionPos = SectionPos.of((long)sectionTag.getLong("SectionPos"));
                ListTag relativeList = sectionTag.getList("ShelfQueues", 10);
                relativeList.forEach(nbt1 -> {
                    try {
                        CompoundTag relativeTag = (CompoundTag)nbt1;
                        if (!relativeTag.contains("RelativePos", 2)) {
                            throw new IllegalArgumentException("Missing relative position");
                        }
                        ListTag entryList = relativeTag.getList("PlayerQueues", 10);
                        if (entryList.isEmpty()) {
                            return;
                        }
                        short relativePos = relativeTag.getShort("RelativePos");
                        BlockPos pos = sectionPos.relativeToBlockPos(relativePos);
                        if (level.isOutsideBuildHeight(pos)) {
                            throw new IllegalArgumentException("Relative position is outside the build height");
                        }
                        LinkedHashMap<UUID, List<QueuedItem>> playerQueues = new LinkedHashMap<UUID, List<QueuedItem>>();
                        entryList.forEach(nbt2 -> {
                            try {
                                CompoundTag entryTag = (CompoundTag)nbt2;
                                UUID owner = entryTag.getUUID("Owner");
                                List items = QueuedItem.CODEC.listOf().parse((DynamicOps)ops, (Object)entryTag.get("Backpacks")).resultOrPartial(arg_0 -> ((Logger)Constants.LOG).error(arg_0)).map(LinkedList::new).orElse(new LinkedList());
                                items.removeIf(item -> item.stack.isEmpty());
                                if (!items.isEmpty()) {
                                    playerQueues.put(owner, items);
                                }
                            }
                            catch (Exception e) {
                                Constants.LOG.error("Error while reading Recall player queues", (Throwable)e);
                            }
                        });
                        if (!playerQueues.isEmpty()) {
                            Short2ObjectOpenHashMap relativeMap = (Short2ObjectOpenHashMap)recall.queues.computeIfAbsent((Object)sectionPos, k -> new Short2ObjectOpenHashMap());
                            relativeMap.put(relativePos, (Object)new ShelfQueue(playerQueues));
                        }
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Error while reading Recall shelf queues", (Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                Constants.LOG.error("Error while reading Recall queues", (Throwable)e);
            }
        });
        return recall;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("Timer", this.timer);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ListTag sectionsList = new ListTag();
        this.queues.forEach((sectionPos, relativeMap) -> {
            CompoundTag sectionTag = new CompoundTag();
            sectionTag.putLong("SectionPos", sectionPos.asLong());
            ListTag relativeList = new ListTag();
            relativeMap.forEach((relativePos, shelfQueue) -> {
                if (shelfQueue.isEmpty()) {
                    return;
                }
                CompoundTag relativeTag = new CompoundTag();
                relativeTag.putShort("RelativePos", relativePos.shortValue());
                ListTag entryList = new ListTag();
                shelfQueue.forEach((owner, items) -> {
                    CompoundTag entryTag = new CompoundTag();
                    entryTag.putUUID("Owner", owner);
                    QueuedItem.CODEC.listOf().encodeStart((DynamicOps)ops, items).resultOrPartial(arg_0 -> ((Logger)Constants.LOG).error(arg_0)).ifPresent(t -> entryTag.put("Backpacks", t));
                    entryList.add((Object)entryTag);
                });
                if (!entryList.isEmpty()) {
                    relativeTag.put("PlayerQueues", (Tag)entryList);
                    relativeList.add((Object)relativeTag);
                }
            });
            if (!relativeList.isEmpty()) {
                sectionTag.put("ShelfQueues", (Tag)relativeList);
                sectionsList.add((Object)sectionTag);
            }
        });
        if (!sectionsList.isEmpty()) {
            tag.put("RecallQueues", (Tag)sectionsList);
        }
        return tag;
    }

    private static final class ShelfQueue {
        @Nullable
        private Map<UUID, List<QueuedItem>> queues;
        private int count;

        private ShelfQueue() {
        }

        private ShelfQueue(@Nullable Map<UUID, List<QueuedItem>> queues) {
            this.queues = queues != null && !queues.isEmpty() ? queues : null;
            this.cleanQueues();
            this.updateCount();
        }

        @Nullable
        public Map<UUID, List<QueuedItem>> queues() {
            return this.queues;
        }

        public void forEach(BiConsumer<UUID, List<QueuedItem>> consumer) {
            if (this.queues != null) {
                this.queues.forEach(consumer);
            }
        }

        public boolean add(ServerPlayer player, int originalIndex, ItemStack backpack, int time) {
            List items;
            if (this.queues == null) {
                this.count = 0;
                this.queues = new HashMap<UUID, List<QueuedItem>>();
            }
            if ((items = this.queues.computeIfAbsent(player.getUUID(), k -> new LinkedList())).size() >= 18) {
                return false;
            }
            items.add(new QueuedItem(originalIndex, backpack.copyAndClear(), time));
            ++this.count;
            return true;
        }

        private void decrementCount() {
            if (this.count > 0) {
                --this.count;
            }
        }

        private void updateCount() {
            if (this.queues != null) {
                this.count = 0;
                for (List<QueuedItem> items : this.queues.values()) {
                    this.count += items.size();
                }
            }
        }

        private void cleanQueues() {
            if (this.queues != null) {
                this.queues.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
                if (this.queues.isEmpty()) {
                    this.queues = null;
                    this.count = 0;
                }
            }
        }

        private boolean isEmpty() {
            return this.queues == null || this.queues.isEmpty();
        }
    }

    private record QueuedItem(int originalIndex, ItemStack stack, int time) {
        private static final Codec<QueuedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("original_index").orElse((Object)-1).forGetter(QueuedItem::originalIndex), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").orElse((Object)ItemStack.EMPTY).forGetter(QueuedItem::stack), (App)Codec.INT.fieldOf("queued_at").orElse((Object)0).forGetter(QueuedItem::time)).apply((Applicative)instance, QueuedItem::new));
    }

    public static interface Access {
        public Recall backpacked$getRecall();
    }
}

