/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.LabelAndDescription;
import com.mrcrayfish.backpacked.common.FilterableItems;
import com.mrcrayfish.backpacked.common.ItemCollection;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record FunnellingAugment(ItemCollection filters, Mode mode) implements Augment<FunnellingAugment>,
FilterableItems<FunnellingAugment>
{
    public static final AugmentType<FunnellingAugment> TYPE = new AugmentType<FunnellingAugment>(Utils.rl("funnelling"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemCollection.CODEC.fieldOf("filters").orElse((Object)ItemCollection.EMPTY).forGetter(FunnellingAugment::filters), (App)Mode.CODEC.fieldOf("mode").orElse((Object)Mode.ALLOW).forGetter(FunnellingAugment::mode)).apply((Applicative)instance, FunnellingAugment::new)), StreamCodec.composite(ItemCollection.STREAM_CODEC, FunnellingAugment::filters, Mode.STREAM_CODEC, FunnellingAugment::mode, FunnellingAugment::new), () -> new FunnellingAugment(ItemCollection.EMPTY, Mode.ALLOW));

    public FunnellingAugment(ItemCollection filters, Mode mode) {
        this.filters = filters = filters.limit((Integer)Config.AUGMENTS.funnelling.maxFilters.get());
        this.mode = mode;
    }

    @Override
    public AugmentType<FunnellingAugment> type() {
        return TYPE;
    }

    @Override
    public FunnellingAugment addItemFilter(Item item) {
        return new FunnellingAugment(this.filters.add(item), this.mode);
    }

    @Override
    public FunnellingAugment removeItemFilter(Item item) {
        return new FunnellingAugment(this.filters.remove(item), this.mode);
    }

    @Override
    public boolean isFilteringItem(Item item) {
        return this.filters.has(item);
    }

    @Override
    public boolean isFilterFull() {
        return this.filters.ids().size() >= (Integer)Config.AUGMENTS.funnelling.maxFilters.get();
    }

    public FunnellingAugment setMode(Mode mode) {
        return new FunnellingAugment(this.filters, mode);
    }

    public boolean test(ItemStack stack) {
        boolean matched = this.filters.has(stack.getItem());
        if (matched && this.mode == Mode.ALLOW) {
            return true;
        }
        if (matched && this.mode == Mode.DISALLOW) {
            return false;
        }
        return this.mode == Mode.DISALLOW;
    }

    public static enum Mode implements StringRepresentable,
    LabelAndDescription
    {
        ALLOW,
        DISALLOW;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private static final String LANGUAGE_KEY = "augment.backpacked.funnelling.mode";
        private final Component name = Component.translatable((String)"augment.backpacked.funnelling.mode", (Object[])new Object[]{Component.translatable((String)"%s.%s".formatted("augment.backpacked.funnelling.mode", this.getSerializedName()))});
        private final Component tooltip = Component.translatable((String)"%s.%s.tooltip".formatted("augment.backpacked.funnelling.mode", this.getSerializedName()));

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public Component label() {
            return this.name;
        }

        @Override
        public Component description() {
            return this.tooltip;
        }

        public Mode other() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DISALLOW;
                case 1 -> ALLOW;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> (Mode)buf.readEnum(Mode.class));
        }
    }

    public static final class ItemFilter {
        private static final Codec<ItemFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(ItemFilter::id)).apply((Applicative)instance, ItemFilter::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemFilter> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ItemFilter::id, ItemFilter::new);
        private final ResourceLocation id;
        private Item item;

        public ItemFilter(ResourceLocation id) {
            this.id = id;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Item item() {
            if (this.item == null) {
                this.item = (Item)BuiltInRegistries.ITEM.get(this.id);
            }
            return this.item;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ItemFilter that = (ItemFilter)obj;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean match(ItemStack stack) {
            return stack.is(this.item());
        }
    }
}

