/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.item.BackpackItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record BackpackState(int cols, int rows, boolean slotsUnlocked) {
    public static final BackpackState UNKNOWN = new BackpackState(0, 0, true);

    public static BackpackState create(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem item2 = (BackpackItem)item;
            int cols = item2.getColumnCount();
            int rows = item2.getRowCount();
            boolean slotsUnlocked = (Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get();
            return new BackpackState(cols, rows, slotsUnlocked);
        }
        return UNKNOWN;
    }

    public boolean isInvalid() {
        if (this.cols != (Integer)Config.BACKPACK.inventory.size.columns.get()) {
            return true;
        }
        if (this.rows != (Integer)Config.BACKPACK.inventory.size.rows.get()) {
            return true;
        }
        return this.slotsUnlocked != (Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get();
    }
}

