/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.InterpolateFunction;
import com.mrcrayfish.framework.api.sync.DataSerializer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public final class UnlockableSlots {
    public static final UnlockableSlots ALL = new UnlockableSlots();
    public static final Codec<UnlockableSlots> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)Codec.INT).fieldOf("slots").forGetter(slots -> List.copyOf(slots.slots)), (App)Codec.INT.fieldOf("maxSlots").forGetter(slots -> slots.maxSlots)).apply((Applicative)builder, UnlockableSlots::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UnlockableSlots> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.collection(HashSet::new)), slots -> slots.slots, (StreamCodec)ByteBufCodecs.INT, slots -> slots.maxSlots, UnlockableSlots::new);
    public static final DataSerializer<UnlockableSlots> SERIALIZER = new DataSerializer(STREAM_CODEC, (obj, provider) -> (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, obj).result().orElse(new CompoundTag()), (tag, provider) -> {
        if (tag instanceof CompoundTag) {
            return CODEC.parse((DynamicOps)NbtOps.INSTANCE, tag).result().orElse(null);
        }
        return null;
    });
    private final Set<Integer> slots;
    private final int maxSlots;
    private final int nextCount;

    private UnlockableSlots() {
        this.slots = new HashSet<Integer>();
        this.maxSlots = -1;
        this.nextCount = 0;
    }

    public UnlockableSlots(int maxSlots) {
        this(new HashSet<Integer>(), maxSlots);
    }

    private UnlockableSlots(List<Integer> slots, int maxSlots) {
        this(new HashSet<Integer>(slots), maxSlots);
    }

    private UnlockableSlots(Set<Integer> slots, int maxSlots) {
        assert (maxSlots > 0);
        this.slots = slots;
        this.maxSlots = maxSlots;
        this.nextCount = UnlockableSlots.calculateUnlockedCount(slots, maxSlots);
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public boolean isUnlocked(int slot) {
        return this.maxSlots == -1 || slot >= 0 && slot < this.maxSlots && this.slots.contains(slot);
    }

    public UnlockableSlots unlockSlot(int slot) {
        if (this.maxSlots == -1) {
            return this;
        }
        if (!this.isUnlockable(slot)) {
            return this;
        }
        HashSet<Integer> newSlots = new HashSet<Integer>(this.slots);
        newSlots.add(slot);
        return new UnlockableSlots(newSlots, this.maxSlots);
    }

    public UnlockableSlots setMaxSlots(int maxSlots) {
        if (this.maxSlots == -1 || this.maxSlots == maxSlots) {
            return this;
        }
        return new UnlockableSlots(this.slots, maxSlots);
    }

    public boolean isUnlockable(int slot) {
        return slot >= 0 && slot < this.maxSlots && !this.slots.contains(slot);
    }

    public int nextUnlockCost(CostModel model, int numberOfSlots) {
        int totalCost = 0;
        for (int nextOffset = 0; nextOffset < numberOfSlots; ++nextOffset) {
            if (model.useCustomCosts()) {
                totalCost += this.getNextCustomCost(model.getCustomCosts(), nextOffset);
                continue;
            }
            int minLevelCost = model.getMinCost();
            int maxLevelCost = model.getMaxCost();
            float costNormal = this.nextCostNormal(maxLevelCost, model.getInterpolateFunction(), nextOffset);
            totalCost += (int)Mth.lerp((float)costNormal, (float)minLevelCost, (float)maxLevelCost);
        }
        return totalCost;
    }

    private int getNextCustomCost(List<Integer> costs, int countOffset) {
        if (!costs.isEmpty()) {
            float normal = Math.clamp((float)(this.nextCount + countOffset) / (float)Math.max(1, this.maxSlots), 0.0f, 1.0f);
            int index = (int)((float)costs.size() * (normal - 0.001f));
            index = Mth.clamp((int)index, (int)0, (int)(costs.size() - 1));
            return Math.max(1, costs.get(index));
        }
        return 1;
    }

    private float nextCostNormal(int maxLevelCost, InterpolateFunction scaling, int countOffset) {
        int nextCount = this.nextCount + countOffset;
        int totalSlots = Math.max(1, this.maxSlots);
        return switch (scaling) {
            default -> throw new MatchException(null, null);
            case InterpolateFunction.LINEAR -> (float)nextCount / (float)totalSlots;
            case InterpolateFunction.SQUARED -> {
                float levelCost = (float)maxLevelCost / (float)(totalSlots * totalSlots);
                yield Math.clamp((levelCost *= (float)(nextCount * nextCount)) + 0.5f, 1.0f, (float)maxLevelCost) / (float)maxLevelCost;
            }
            case InterpolateFunction.CUBIC -> {
                float levelCost = (float)maxLevelCost / (float)(totalSlots * totalSlots * totalSlots);
                yield Math.clamp((levelCost *= (float)(nextCount * nextCount * nextCount)) + 0.5f, 1.0f, (float)maxLevelCost) / (float)maxLevelCost;
            }
        };
    }

    private static int calculateUnlockedCount(Set<Integer> slots, int maxSlots) {
        int count = 1;
        for (int slot : slots) {
            if (slot >= maxSlots) continue;
            ++count;
        }
        return count;
    }

    public int hashCode() {
        return Objects.hash(this.slots, this.maxSlots);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnlockableSlots other = (UnlockableSlots)o;
        return this.maxSlots == other.maxSlots && this.slots.equals(other.slots);
    }
}

