/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.BlockSnapshot;
import com.mrcrayfish.backpacked.common.challenge.PredicateUtils;
import com.mrcrayfish.backpacked.common.predicates.BlockPositionPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public record BlockSnapshotPredicate(Optional<BlockPredicate> block, Optional<BlockPositionPredicate> position, Optional<HolderSet<Biome>> biomes, Optional<HolderSet<Structure>> structures, Optional<ResourceKey<Level>> dimension) {
    public static final Codec<BlockSnapshotPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(BlockSnapshotPredicate::block), (App)BlockPositionPredicate.CODEC.optionalFieldOf("position").forGetter(BlockSnapshotPredicate::position), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(BlockSnapshotPredicate::biomes), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structures").forGetter(BlockSnapshotPredicate::structures), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("dimension").forGetter(BlockSnapshotPredicate::dimension)).apply((Applicative)builder, BlockSnapshotPredicate::new));

    public boolean test(BlockSnapshot snapshot) {
        if (!PredicateUtils.match(this.block, snapshot.state(), snapshot.tag())) {
            return false;
        }
        if (!this.position.map(predicate -> predicate.test(snapshot.pos())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.biomes.map(set -> set.contains(snapshot.biome())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.structures.map(holders -> snapshot.level().structureManager().getStructureWithPieceAt(snapshot.pos(), holders).isValid()).orElse(true).booleanValue()) {
            return false;
        }
        return this.dimension.map(key -> key == snapshot.level().dimension()).orElse(true);
    }
}

