/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.augment.AugmentHandler;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;

public class YoureInGraveDangerSupport {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(YoureInGraveDangerSupport::onRegisterCompat);
    }

    private static void onRegisterCompat(YigdEvents.LoadModCompatEvent event) {
        event.addModCompat((InvModCompat)new BackpackedCompat());
    }

    private static class BackpackedCompat
    implements InvModCompat<List<Pair<Integer, GraveItem>>> {
        private BackpackedCompat() {
        }

        public String getModName() {
            return "backpacked";
        }

        public void clear(ServerPlayer player) {
            BackpackHelper.removeAllBackpacks((Player)player);
        }

        public CompatComponent<List<Pair<Integer, GraveItem>>> readNbt(CompoundTag tag, HolderLookup.Provider provider) {
            ArrayList<Pair<Integer, GraveItem>> backpacks = new ArrayList<Pair<Integer, GraveItem>>();
            if (tag.contains("Backpacks", 9)) {
                ListTag list = tag.getList("Backpacks", 10);
                list.forEach(nbt -> {
                    if (nbt instanceof CompoundTag) {
                        CompoundTag slotTag = (CompoundTag)nbt;
                        int slot = slotTag.getInt("Slot");
                        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slotTag.getCompound("Item"));
                        DropRule dropRule = slotTag.getBoolean("Recalled") ? DropRule.DESTROY : DropRule.PUT_IN_GRAVE;
                        backpacks.add(Pair.of((Object)slot, (Object)new GraveItem(stack, dropRule)));
                    }
                });
            }
            return new BackpackedCompatComponent(backpacks);
        }

        public CompatComponent<List<Pair<Integer, GraveItem>>> getNewComponent(ServerPlayer player) {
            return new BackpackedCompatComponent(player);
        }
    }

    private static class BackpackedCompatComponent
    extends CompatComponent<List<Pair<Integer, GraveItem>>> {
        public BackpackedCompatComponent(ServerPlayer player) {
            super(player);
        }

        public BackpackedCompatComponent(List<Pair<Integer, GraveItem>> backpacks) {
            super(backpacks);
        }

        public List<Pair<Integer, GraveItem>> getInventory(ServerPlayer player) {
            ArrayList<Pair<Integer, GraveItem>> list = new ArrayList<Pair<Integer, GraveItem>>();
            NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks((Player)player);
            for (int i = 0; i < backpacks.size(); ++i) {
                ItemStack stack = (ItemStack)backpacks.get(i);
                if (stack.isEmpty()) continue;
                list.add((Pair<Integer, GraveItem>)new Pair((Object)i, (Object)new GraveItem(stack.copy(), DropRule.PUT_IN_GRAVE)));
            }
            return list;
        }

        public NonNullList<GraveItem> merge(CompatComponent<?> otherComponent, ServerPlayer player) {
            BackpackedCompatComponent component = (BackpackedCompatComponent)otherComponent;
            ((List)this.inventory).addAll((Collection)component.inventory);
            return NonNullList.create();
        }

        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extra = NonNullList.create();
            ((List)this.inventory).forEach(pair -> {
                int index = (Integer)pair.getFirst();
                GraveItem graveItem = (GraveItem)pair.getSecond();
                if (BackpackHelper.getBackpackStack((Player)player, index).isEmpty() && BackpackHelper.setBackpackStack((Player)player, graveItem.stack.copyAndClear(), index)) {
                    return;
                }
                extra.add((Object)graveItem.stack);
            });
            return extra;
        }

        public void handleDropRules(DeathContext context) {
            ((List)this.inventory).forEach(pair -> {
                int index = (Integer)pair.getFirst();
                GraveItem graveItem = (GraveItem)pair.getSecond();
                ItemStack stack = graveItem.stack;
                if (this.hasRecallAugment(stack)) {
                    ServerPlayer player = context.player();
                    RecallAugment augment = (RecallAugment)Augments.get(stack).findEnabledAndCast((AugmentType)ModAugmentTypes.RECALL.get());
                    if (augment != null && AugmentHandler.recallBackpack(player, index, stack, augment)) {
                        graveItem.dropRule = DropRule.DESTROY;
                    }
                }
            });
        }

        public NonNullList<GraveItem> getAsGraveItemList() {
            NonNullList drops = NonNullList.create();
            if (!((List)this.inventory).isEmpty()) {
                ((List)this.inventory).forEach(pair -> drops.add((Object)((GraveItem)pair.getSecond())));
            }
            return drops;
        }

        public CompatComponent<List<Pair<Integer, GraveItem>>> filterInv(Predicate<DropRule> predicate) {
            ArrayList<Pair<Integer, GraveItem>> list = new ArrayList<Pair<Integer, GraveItem>>();
            ((List)this.inventory).forEach(pair -> {
                GraveItem graveItem = (GraveItem)pair.getSecond();
                if (predicate.test(graveItem.dropRule)) {
                    list.add((Pair<Integer, GraveItem>)pair);
                }
            });
            return new BackpackedCompatComponent(list);
        }

        public boolean removeItem(Predicate<ItemStack> predicate, int count) {
            for (Pair pair : (List)this.inventory) {
                ItemStack stack = ((GraveItem)pair.getSecond()).stack;
                if (!predicate.test(stack)) continue;
                stack.shrink(Math.min(stack.getCount(), count));
                return true;
            }
            return false;
        }

        public void clear() {
            this.inventory = new ArrayList();
        }

        public CompoundTag writeNbt(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            ((List)this.inventory).forEach(pair -> {
                CompoundTag slotTag = new CompoundTag();
                slotTag.putInt("Slot", ((Integer)pair.getFirst()).intValue());
                GraveItem graveItem = (GraveItem)pair.getSecond();
                slotTag.put("Item", graveItem.stack.saveOptional(provider));
                slotTag.putBoolean("Recalled", graveItem.dropRule == DropRule.DESTROY);
                list.add((Object)slotTag);
            });
            tag.put("Backpacks", (Tag)list);
            return tag;
        }

        private boolean hasRecallAugment(ItemStack stack) {
            RecallAugment augment = (RecallAugment)Augments.get(stack).findEnabledAndCast((AugmentType)ModAugmentTypes.RECALL.get());
            return augment != null && augment.shelfKey().isPresent();
        }
    }
}

