/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.item.BackpackItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ManagementInventory
implements Container {
    private final ServerPlayer player;
    private final int size;

    public ManagementInventory(ServerPlayer player) {
        this.player = player;
        this.size = ManagementInventory.getMaxEquipable();
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return BackpackHelper.getFirstBackpackStack((Player)this.player).isEmpty();
    }

    public ItemStack getItem(int index) {
        return BackpackHelper.getBackpackStack((Player)this.player, index);
    }

    public ItemStack removeItem(int index, int count) {
        return count > 0 ? BackpackHelper.getBackpackStack((Player)this.player, index).split(count) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = BackpackHelper.getBackpackStack((Player)this.player, index);
        if (!stack.isEmpty()) {
            BackpackHelper.setBackpackStack((Player)this.player, ItemStack.EMPTY, index);
        }
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        BackpackHelper.setBackpackStack((Player)this.player, stack, index);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((Player)this.player);
        return slots.isUnlocked(index) && stack.getItem() instanceof BackpackItem;
    }

    public boolean canTakeItem(Container container, int index, ItemStack stack) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((Player)this.player);
        return slots.isUnlocked(index);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return this.player.isAlive() && this.size == ManagementInventory.getMaxEquipable();
    }

    public void clearContent() {
        for (int i = 0; i < this.size; ++i) {
            BackpackHelper.setBackpackStack((Player)this.player, ItemStack.EMPTY, i);
        }
    }

    public static int getMaxEquipable() {
        return (Integer)Config.BACKPACK.equipable.maxEquipable.get();
    }
}

