/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.PaymentItem;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.container.CustomContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.SyncUnlockableSlots;
import com.mrcrayfish.backpacked.inventory.container.UnlockableController;
import com.mrcrayfish.backpacked.inventory.container.data.BackpackContainerData;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockSlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackContainerMenu
extends CustomContainerMenu
implements SyncUnlockableSlots {
    public static final int MAX_COLUMNS = 23;
    public static final int MAX_ROWS = 11;
    private final Container backpackInventory;
    private final int ownerId;
    private final int backpackIndex;
    private final int cols;
    private final int rows;
    private final boolean owner;
    private final UnlockableController controller;
    private final Pagination pagination;
    private Augments augments;

    public BackpackContainerMenu(int id, Inventory playerInventory, BackpackContainerData data) {
        this(id, playerInventory, (Container)new SimpleContainer(Mth.clamp((int)data.columns(), (int)1, (int)23) * Mth.clamp((int)data.rows(), (int)1, (int)11)), -1, data.backpackIndex(), data.columns(), data.rows(), data.owner(), data.slots(), data.pagination(), data.augments());
    }

    public BackpackContainerMenu(int id, Inventory playerInventory, Container backpackContainer, int ownerId, int backpackIndex, int cols, int rows, boolean owner, UnlockableSlots slots, Pagination pagination, Augments augments) {
        super((MenuType)ModContainers.BACKPACK.get(), id);
        this.backpackInventory = backpackContainer;
        this.ownerId = ownerId;
        this.backpackIndex = backpackIndex;
        this.cols = Mth.clamp((int)cols, (int)1, (int)23);
        this.rows = Mth.clamp((int)rows, (int)1, (int)11);
        this.owner = owner;
        this.pagination = pagination;
        this.controller = new BackpackUnlockableController(this, slots, List.of(playerInventory, backpackContainer));
        this.augments = augments;
        BackpackContainerMenu.checkContainerSize((Container)backpackContainer, (int)(this.cols * this.rows));
        backpackContainer.startOpen(playerInventory.player);
        int backpackWidth = 11 + Math.max(162, this.cols * 18) + 11;
        int backpackSlotsWidth = this.cols * 18;
        int backpackSlotsX = Math.max((backpackWidth - backpackSlotsWidth) / 2, 0) + 1;
        int backpackSlotsY = 28;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.addSlot(new BackpackSlot(this.controller, backpackContainer, x + y * cols, backpackSlotsX + x * 18, backpackSlotsY + y * 18));
            }
        }
        int inventorySlotsWidth = 162;
        int inventorySlotsX = Math.max((backpackWidth - inventorySlotsWidth) / 2, 0) + 1;
        int inventorySlotsY = 26 + this.rows * 18 + 15 + 3 + 19;
        this.addPlayerInventorySlots(playerInventory, inventorySlotsX, inventorySlotsY);
    }

    public Container getBackpackInventory() {
        return this.backpackInventory;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public int getBackpackIndex() {
        return this.backpackIndex;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public UnlockableController getController() {
        return this.controller;
    }

    public Augments getAugments() {
        return this.augments;
    }

    public void setAugments(Augments augments) {
        this.augments = augments;
    }

    public boolean stillValid(Player playerIn) {
        return this.backpackInventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            copy = slotStack.copy();
            if (index < this.rows * this.cols ? !this.moveItemStackTo(slotStack, this.rows * this.cols, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.rows * this.cols, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.backpackInventory.stopOpen(playerIn);
    }

    private ItemStack getBackpackStack() {
        Container container = this.backpackInventory;
        if (container instanceof ShelfBlockEntity.BackpackShelfContainer) {
            ShelfBlockEntity.BackpackShelfContainer container2 = (ShelfBlockEntity.BackpackShelfContainer)container;
            return container2.getBlockEntity().getBackpack();
        }
        container = this.backpackInventory;
        if (container instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)container;
            return inventory.getBackpackStack();
        }
        return ItemStack.EMPTY;
    }

    public void openManagement(ServerPlayer player) {
        Container container = this.backpackInventory;
        if (container instanceof ShelfBlockEntity.BackpackShelfContainer) {
            ShelfBlockEntity.BackpackShelfContainer container2 = (ShelfBlockEntity.BackpackShelfContainer)container;
            container2.getBlockEntity().openShelfManagement(player);
        } else if (this.backpackInventory instanceof BackpackInventory) {
            BackpackItem.openBackpackManagement(player, true);
        }
    }

    @Override
    public void handleSyncSlots(ServerPlayer unlockingPlayer, List<UnlockableSlot> unlockedSlots) {
        List<Integer> slotIndexes = unlockedSlots.stream().map(slot -> slot.index).toList();
        List players = unlockingPlayer.server.getPlayerList().getPlayers();
        players.forEach(otherPlayer -> {
            AbstractContainerMenu patt0$temp = otherPlayer.containerMenu;
            if (patt0$temp instanceof BackpackContainerMenu) {
                BackpackContainerMenu otherMenu = (BackpackContainerMenu)patt0$temp;
                if (this.backpackInventory == otherMenu.backpackInventory) {
                    if (otherPlayer != unlockingPlayer) {
                        otherMenu.controller.cachedSlots = this.controller.cachedSlots;
                    }
                    Network.PLAY.sendToPlayer(() -> otherPlayer, (Object)new MessageSyncUnlockSlot(slotIndexes));
                }
            }
        });
    }

    private static class BackpackUnlockableController
    extends UnlockableController {
        private final BackpackContainerMenu menu;
        private final List<Container> paymentContainers;

        private BackpackUnlockableController(BackpackContainerMenu menu, UnlockableSlots slots, List<Container> paymentContainers) {
            super(slots);
            this.menu = menu;
            this.paymentContainers = paymentContainers;
        }

        @Override
        public Optional<UnlockableSlots> getSlots(Player player) {
            ItemStack backpack = this.menu.getBackpackStack();
            if (!backpack.isEmpty()) {
                return Optional.ofNullable((UnlockableSlots)backpack.get((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get()));
            }
            return Optional.empty();
        }

        @Override
        public void setSlots(Player player, UnlockableSlots slots) {
            ItemStack backpack = this.menu.getBackpackStack();
            if (!backpack.isEmpty()) {
                backpack.set((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
            }
        }

        @Override
        public CostModel getCostModel() {
            return Config.BACKPACK.inventory.slots.unlockCost;
        }

        @Override
        public PaymentItem getPaymentItem() {
            return Config.getInventoryPaymentItem();
        }

        @Override
        public List<Container> getPaymentContainers() {
            return this.paymentContainers;
        }
    }
}

