/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackManagementMenu;
import com.mrcrayfish.backpacked.inventory.container.CustomContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.inventory.container.slot.ConditionalSlot;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackShelfMenu
extends CustomContainerMenu {
    private static final ResourceLocation EMPTY_SLOT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"item/empty_backpack_slot");
    private final Container managementContainer;
    private final Container shelfContainer;

    public BackpackShelfMenu(int windowId, Inventory playerInventory, ManagementContainerData customData) {
        this(windowId, playerInventory, (Container)new SimpleContainer(ManagementInventory.getMaxEquipable()), (Container)new SimpleContainer(1), customData.slots());
    }

    public BackpackShelfMenu(int windowId, Inventory playerInventory, Container managementContainer, Container shelfContainer, UnlockableSlots managementSlots) {
        super((MenuType)ModContainers.BACKPACK_SHELF.get(), windowId);
        this.managementContainer = managementContainer;
        this.shelfContainer = shelfContainer;
        BackpackShelfMenu.checkContainerSize((Container)managementContainer, (int)ManagementInventory.getMaxEquipable());
        BackpackShelfMenu.checkContainerSize((Container)shelfContainer, (int)1);
        this.addSlot(new ConditionalSlot(shelfContainer, 0, 80, 1, stack -> stack.getItem() instanceof BackpackItem));
        BackpackManagementMenu.ManagementUnlockableController controller = new BackpackManagementMenu.ManagementUnlockableController(managementSlots, List.of(playerInventory));
        int managementSize = managementContainer.getContainerSize();
        for (int i = 0; i < managementSize; ++i) {
            this.addSlot(new UnlockableSlot(controller, managementContainer, i, i * 18 + (176 - managementSize * 18) / 2 + 1, 60).setIcon(EMPTY_SLOT).setPredicate(stack -> stack.getItem() instanceof BackpackItem));
        }
        this.addPlayerInventorySlots(playerInventory, 8, 102);
    }

    public Container getManagementContainer() {
        return this.managementContainer;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            copy = slotStack.copy();
            if (index < 1 ? !this.moveItemStackTo(slotStack, 1, this.slots.size(), false) : !this.moveItemStackTo(slotStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }

    public boolean stillValid(Player player) {
        return this.managementContainer.stillValid(player) && this.shelfContainer.stillValid(player);
    }
}

