/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public abstract class UnlockableContainer
implements Container {
    protected final int size;
    protected final NonNullList<ItemStack> items;

    public UnlockableContainer(int size) {
        this.size = size;
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    protected abstract UnlockableSlots getUnlockableSlots();

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.size; ++slot) {
            if (!slots.isUnlocked(slot) || ((ItemStack)this.items.get(slot)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        UnlockableSlots slots = this.getUnlockableSlots();
        return slot >= 0 && slot < this.size && slots.isUnlocked(slot) ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int count) {
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot)) {
            ItemStack stack = ContainerHelper.removeItem(this.items, (int)slot, (int)count);
            if (!stack.isEmpty()) {
                this.setChanged();
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack;
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot) && !(stack = (ItemStack)this.items.get(slot)).isEmpty()) {
            this.items.set(slot, (Object)ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot)) {
            this.items.set(slot, (Object)stack);
            stack.limitSize(this.getMaxStackSize(stack));
            this.setChanged();
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getUnlockableSlots().isUnlocked(slot);
    }

    public boolean canTakeItem(Container container, int slot, ItemStack stack) {
        return this.getUnlockableSlots().isUnlocked(slot);
    }

    public int countItem(Item item) {
        int count = 0;
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack stack;
            if (!slots.isUnlocked(slot) || !(stack = (ItemStack)this.items.get(slot)).is(item)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack stack;
            if (!slots.isUnlocked(slot) || !predicate.test(stack = (ItemStack)this.items.get(slot))) continue;
            return true;
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void copyFrom(ItemContainerContents contents) {
        contents.copyInto(this.items);
    }

    public ItemContainerContents createContents() {
        return ItemContainerContents.fromItems(this.items);
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public void save(CompoundTag tag, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public ItemStack addItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            ItemStack copy = stack.copy();
            this.mergeIntoExistingStacks(copy);
            if (!copy.isEmpty()) {
                this.moveStackIntoFirstEmptyUnlockedSlot(copy);
            }
            return copy.isEmpty() ? ItemStack.EMPTY : copy;
        }
        return ItemStack.EMPTY;
    }

    protected void mergeIntoExistingStacks(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack slotStack = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack)) continue;
            int maxStackSize = this.getMaxStackSize(slotStack);
            int growSize = Math.min(stack.getCount(), maxStackSize - slotStack.getCount());
            if (growSize <= 0) continue;
            slotStack.grow(growSize);
            stack.shrink(growSize);
            this.setChanged();
        }
    }

    protected void moveStackIntoFirstEmptyUnlockedSlot(ItemStack stack) {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int i = 0; i < this.size; ++i) {
            ItemStack slotStack = this.getItem(i);
            if (!slots.isUnlocked(i) || !slotStack.isEmpty() || !this.canPlaceItem(i, stack)) continue;
            this.setItem(i, stack.copyAndClear());
            break;
        }
    }
}

