/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackManagementMenu;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.menu.IMenuData;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends Item {
    public static final Component BACKPACK_TRANSLATION = Component.translatable((String)"container.backpack");
    public static final Component BACKPACK_MANAGEMENT_TRANSLATION = Component.translatable((String)"container.backpack_management");

    public BackpackItem(Item.Properties properties) {
        super(properties.component((DataComponentType)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT).component((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)new UnlockableSlots(0)).component((DataComponentType)ModDataComponents.AUGMENTS.get(), (Object)Augments.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && BackpackHelper.equipBackpack(player, stack)) {
            level.playSeededSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), player.getSoundSource(), 1.0f, 1.0f, player.getRandom().nextLong());
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public int getColumnCount() {
        return (Integer)Config.BACKPACK.inventory.size.columns.get();
    }

    public int getRowCount() {
        return (Integer)Config.BACKPACK.inventory.size.rows.get();
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public static boolean openBackpack(ServerPlayer ownerPlayer, ServerPlayer openingPlayer, int backpackIndex) {
        BackpackInventory inventory = ((BackpackedInventoryAccess)ownerPlayer).backpacked$GetBackpackInventory(backpackIndex);
        if (inventory != null) {
            ItemStack backpack = inventory.getBackpackStack();
            Item item = backpack.getItem();
            if (!(item instanceof BackpackItem)) {
                return false;
            }
            BackpackItem item2 = (BackpackItem)item;
            if (Objects.equals(ownerPlayer, openingPlayer)) {
                ModSyncedDataKeys.SELECTED_BACKPACK.setValue((Entity)ownerPlayer, (Object)backpackIndex);
            }
            Component title = backpack.has(DataComponents.CUSTOM_NAME) ? backpack.getHoverName() : BACKPACK_TRANSLATION;
            int cols = item2.getColumnCount();
            int rows = item2.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            UnlockableSlots slots = item2.getUnlockableSlots(backpack);
            Pagination pagination = BackpackHelper.createPaginationInfo((Player)ownerPlayer, backpackIndex);
            Augments augments = Augments.get(backpack);
            Services.BACKPACK.openBackpackScreen(openingPlayer, inventory, ownerPlayer.getId(), backpackIndex, cols, rows, owner, slots, pagination, augments, title);
            return true;
        }
        if (Objects.equals(ownerPlayer, openingPlayer)) {
            BackpackItem.openBackpackManagement(ownerPlayer, false);
        }
        return false;
    }

    public static void openBackpackManagement(ServerPlayer player, boolean showInventoryButton) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((Player)player);
        FrameworkAPI.openMenuWithData((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, entity) -> {
            SimpleContainerData data = new SimpleContainerData(1);
            data.set(0, BackpackHelper.getFirstBackpackStack((Player)player).isEmpty() ? 0 : 1);
            return new BackpackManagementMenu(id, player.getInventory(), new ManagementInventory(player), (ContainerData)data, slots, showInventoryButton);
        }, BACKPACK_MANAGEMENT_TRANSLATION), (IMenuData)new ManagementContainerData(slots, showInventoryButton));
    }

    @Nullable
    public UnlockableSlots getUnlockableSlots(ItemStack stack) {
        if (!stack.is((Item)this)) {
            return null;
        }
        if (((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            return UnlockableSlots.ALL;
        }
        UnlockableSlots slots = (UnlockableSlots)stack.get((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get());
        if (slots == null) {
            slots = new UnlockableSlots(this.getColumnCount() * this.getRowCount());
            stack.set((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
            return slots;
        }
        int maxSlots = this.getColumnCount() * this.getRowCount();
        if (slots.getMaxSlots() != maxSlots) {
            slots = slots.setMaxSlots(maxSlots);
            stack.set((DataComponentType)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
        }
        return slots;
    }
}

