/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InventoryHelper {
    public static void mergeItemsOrSpawnIntoLevel(NonNullList<ItemStack> source, NonNullList<ItemStack> target, Level level, Vec3 pos) {
        for (int i = 0; i < source.size(); ++i) {
            ItemStack stack = (ItemStack)source.get(i);
            if (i < target.size()) {
                target.set(i, (Object)stack.copy());
                continue;
            }
            InventoryHelper.spawnStack(stack, level, pos);
        }
    }

    public static void mergeInventoryOrSpawnIntoLevel(Container source, Container target, Level level, Vec3 pos) {
        for (int i = 0; i < source.getContainerSize(); ++i) {
            ItemStack stack = source.getItem(i);
            if (i < target.getContainerSize() && target.canPlaceItem(i, stack)) {
                target.setItem(i, stack.copy());
                continue;
            }
            InventoryHelper.spawnStack(stack, level, pos);
        }
    }

    public static void spawnStack(ItemStack stack, Level level, Vec3 pos) {
        if (!level.isClientSide()) {
            ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, stack.copyAndClear());
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    public static Stream<ItemStack> streamFor(Container container) {
        return IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0));
    }

    public static boolean hasRemovableItemAndCount(Item item, int count, List<Container> containers) {
        int found = 0;
        for (Container container : containers) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty() || !stack.is(item) || !container.canTakeItem(container, i, stack) || (found += stack.getCount()) < count) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<Runnable> createRemoveItemJob(Item item, int count, List<Container> containers) {
        if (item == Items.AIR || count < 0 || containers.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Runnable> transactions = new ArrayList<Runnable>();
        block0: for (Container container : containers) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty() || !stack.is(item) || !container.canTakeItem(container, i, stack)) continue;
                int shrink = Math.min(stack.getCount(), count);
                count -= shrink;
                transactions.add(() -> {
                    stack.shrink(shrink);
                    container.setChanged();
                });
                if (shrink == 0) break block0;
            }
        }
        if (count == 0) {
            return Optional.of(() -> transactions.forEach(Runnable::run));
        }
        return Optional.empty();
    }
}

