/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.sawmill.trades.BiomeToWoodList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record BiomeWoodToItemListing(boolean buys, String childKey, int woodPrice, ItemCost emeralds, int maxTrades, int xp, float priceMult, int level, BiomeToWoodList biomeWoods) implements ModItemListing
{
    public static final MapCodec<BiomeWoodToItemListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("buys", (Object)true).forGetter(BiomeWoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(BiomeWoodToItemListing::childKey), (App)ExtraCodecs.POSITIVE_INT.fieldOf("wood_block_amount").forGetter(BiomeWoodToItemListing::woodPrice), (App)ItemCost.CODEC.fieldOf("emeralds").forGetter(BiomeWoodToItemListing::emeralds), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(BiomeWoodToItemListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(BiomeWoodToItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(BiomeWoodToItemListing::level), (App)BiomeToWoodList.CODEC.optionalFieldOf("biome_woods", (Object)new BiomeToWoodList(Map.of())).forGetter(BiomeWoodToItemListing::biomeWoods)).apply((Applicative)i, BiomeWoodToItemListing::createDefault));

    private static BiomeWoodToItemListing createDefault(boolean buys, String wood, int woodAmount, ItemCost emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, BiomeToWoodList biomeWoods) {
        return new BiomeWoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, biomeWoods);
    }

    public boolean isValid() {
        return VanillaWoodTypes.OAK.getItemOfThis(this.childKey) != null;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    private WoodType getTypeSpecificWoodType(Entity trader, RandomSource random) {
        if (trader instanceof VillagerDataHolder) {
            VillagerDataHolder d = (VillagerDataHolder)trader;
            List<WoodType> list = this.biomeWoods.getWoodsForType(d.getVillagerData().getType());
            return list.get(random.nextInt(list.size()));
        }
        return null;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        WoodType type = this.getTypeSpecificWoodType(trader, random);
        if (type == null) {
            return null;
        }
        Item woodItem = type.getItemOfThis(this.childKey);
        if (woodItem != null && woodItem != Items.AIR) {
            ItemCost itemCost = new ItemCost((ItemLike)woodItem, this.woodPrice);
            ItemCost emerald = this.emeralds;
            if (this.buys) {
                return new MerchantOffer(itemCost, Optional.empty(), emerald.itemStack(), this.maxTrades, this.xp, this.priceMult);
            }
            return new MerchantOffer(emerald, Optional.empty(), itemCost.itemStack(), this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }
}

