/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class SlashParticleEffect
implements ParticleOptions {
    private final ParticleType<SlashParticleEffect> type;
    private final float pitch;
    private final float yaw;
    private final float localYaw;
    private final float roll;
    private final float scale;
    private final boolean light;
    private final long color_rgba;

    public SlashParticleEffect(ParticleType<SlashParticleEffect> type, float scale, float pitch, float yaw, float localYaw, float roll, boolean light, long color_rgba) {
        this.type = type;
        this.scale = scale;
        this.pitch = pitch;
        this.yaw = yaw;
        this.localYaw = localYaw;
        this.roll = roll;
        this.light = light;
        this.color_rgba = color_rgba;
    }

    public ParticleType<SlashParticleEffect> getType() {
        return this.type;
    }

    public float getScale() {
        return this.scale;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getLocalYaw() {
        return this.localYaw;
    }

    public float getRoll() {
        return this.roll;
    }

    public boolean getLight() {
        return this.light;
    }

    public long getColorRGBA() {
        return this.color_rgba;
    }

    public static MapCodec<SlashParticleEffect> createCodec(ParticleType<SlashParticleEffect> particleType) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").forGetter(SlashParticleEffect::getScale), (App)Codec.FLOAT.fieldOf("pitch").forGetter(SlashParticleEffect::getPitch), (App)Codec.FLOAT.fieldOf("yaw").forGetter(SlashParticleEffect::getYaw), (App)Codec.FLOAT.fieldOf("local_yaw").forGetter(SlashParticleEffect::getLocalYaw), (App)Codec.FLOAT.fieldOf("roll").forGetter(SlashParticleEffect::getRoll), (App)Codec.BOOL.fieldOf("light").forGetter(SlashParticleEffect::getLight), (App)Codec.LONG.fieldOf("color_rgba").forGetter(SlashParticleEffect::getColorRGBA)).apply((Applicative)instance, (scale, pitch, yaw, localYaw, roll, light, color_rgba) -> new SlashParticleEffect(particleType, scale.floatValue(), pitch.floatValue(), yaw.floatValue(), localYaw.floatValue(), roll.floatValue(), (boolean)light, (long)color_rgba)));
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, SlashParticleEffect> createPacketCodec(final ParticleType<SlashParticleEffect> particleType) {
        return new StreamCodec<RegistryFriendlyByteBuf, SlashParticleEffect>(){

            public SlashParticleEffect decode(RegistryFriendlyByteBuf buf) {
                float scale = buf.readFloat();
                float pitch = buf.readFloat();
                float yaw = buf.readFloat();
                float localYaw = buf.readFloat();
                float roll = buf.readFloat();
                boolean light = buf.readBoolean();
                long color_rgba = buf.readLong();
                return new SlashParticleEffect((ParticleType<SlashParticleEffect>)particleType, scale, pitch, yaw, localYaw, roll, light, color_rgba);
            }

            public void encode(RegistryFriendlyByteBuf buf, SlashParticleEffect effect) {
                buf.writeFloat(effect.getScale());
                buf.writeFloat(effect.getPitch());
                buf.writeFloat(effect.getYaw());
                buf.writeFloat(effect.getLocalYaw());
                buf.writeFloat(effect.getRoll());
                buf.writeBoolean(effect.getLight());
                buf.writeLong(effect.getColorRGBA());
            }
        };
    }
}

