/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging;

import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerLevel;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.Nullable;

public class DhLogger
implements IConfigListener {
    private static final List<WeakReference<DhLogger>> LOGGER_REF_LIST = Collections.synchronizedList(new LinkedList());
    private static final ThreadPoolExecutor TICKER_THREAD = ThreadUtil.makeSingleDaemonThreadPool("Log Ticker");
    private static final Logger LOGGER = LogManager.getLogger();
    private static IMinecraftClientWrapper mc_client = null;
    private static EDhApiLoggerLevel globalMaxFileLevel = EDhApiLoggerLevel.ALL;
    private static EDhApiLoggerLevel globalMaxChatLevel = EDhApiLoggerLevel.ALL;
    private EDhApiLoggerLevel fileLevel;
    private EDhApiLoggerLevel chatLevel;
    private boolean delayedSetupComplete = false;
    @Nullable
    private final ConfigEntry<EDhApiLoggerLevel> fileLevelConfig;
    @Nullable
    private final ConfigEntry<EDhApiLoggerLevel> chatLevelConfig;
    private final int maxLogCountPerSecond;
    private final AtomicInteger logCountsThisSecondRef = new AtomicInteger(0);
    private final Logger logger;

    public static void runDelayedConfigSetup() {
        LOGGER.info("Applying config to loggers");
        LOGGER_REF_LIST.forEach(loggerRef -> {
            DhLogger logger = (DhLogger)loggerRef.get();
            if (logger != null && !logger.delayedSetupComplete) {
                logger.delayedSetupComplete = true;
                Config.Common.Logging.globalChatMaxLevel.addListener(logger);
                Config.Common.Logging.globalFileMaxLevel.addListener(logger);
                logger.onConfigValueSet();
            }
        });
    }

    public DhLogger(String loggerName, @Nullable ConfigEntry<EDhApiLoggerLevel> chatLevelConfig, @Nullable ConfigEntry<EDhApiLoggerLevel> fileLevelConfig, int maxLogPerSec) {
        this.logger = LogManager.getLogger((String)("DistantHorizons-" + loggerName));
        this.maxLogCountPerSecond = maxLogPerSec;
        this.chatLevelConfig = chatLevelConfig;
        if (this.chatLevelConfig != null) {
            this.chatLevel = this.chatLevelConfig.get();
            this.chatLevelConfig.addListener(this);
        } else {
            this.chatLevel = EDhApiLoggerLevel.DISABLED;
        }
        this.fileLevelConfig = fileLevelConfig;
        if (this.fileLevelConfig != null) {
            this.fileLevel = this.fileLevelConfig.get();
            this.fileLevelConfig.addListener(this);
        } else {
            this.fileLevel = EDhApiLoggerLevel.ALL;
        }
        LOGGER_REF_LIST.add(new WeakReference<DhLogger>(this));
    }

    @Override
    public void onConfigValueSet() {
        if (this.fileLevelConfig != null) {
            this.fileLevel = this.fileLevelConfig.get();
        }
        if (this.chatLevelConfig != null) {
            this.chatLevel = this.chatLevelConfig.get();
        }
        globalMaxFileLevel = Config.Common.Logging.globalFileMaxLevel.get();
        globalMaxChatLevel = Config.Common.Logging.globalChatMaxLevel.get();
    }

    public boolean canLog() {
        if (this.fileLevel == EDhApiLoggerLevel.DISABLED && this.chatLevel == EDhApiLoggerLevel.DISABLED) {
            return false;
        }
        if (globalMaxFileLevel == EDhApiLoggerLevel.DISABLED && globalMaxChatLevel == EDhApiLoggerLevel.DISABLED) {
            return false;
        }
        return this.maxLogCountPerSecond <= 0 || this.logCountsThisSecondRef.get() < this.maxLogCountPerSecond;
    }

    public void fatal(String str, Object ... param) {
        this.log(Level.FATAL, str, param);
    }

    public void error(String str, Object ... param) {
        this.log(Level.ERROR, str, param);
    }

    public void warn(String str, Object ... param) {
        this.log(Level.WARN, str, param);
    }

    public void info(String str, Object ... param) {
        this.log(Level.INFO, str, param);
    }

    public void debug(String str, Object ... param) {
        this.log(Level.DEBUG, str, param);
    }

    public void trace(String str, Object ... param) {
        this.log(Level.TRACE, str, param);
    }

    public void log(Level level, String str, Object ... param) {
        if (!this.canLog()) {
            return;
        }
        Message msg = this.logger.getMessageFactory().newMessage(str, param);
        String msgStr = msg.getFormattedMessage();
        boolean messageLogged = false;
        if (DhLogger.canLogThisLevel(this.fileLevel.level, DhLogger.globalMaxFileLevel.level, level)) {
            Level logLevel;
            Level level2 = logLevel = DhLogger.loggingLevelIsLessSpecificThan(level, Level.INFO) ? Level.INFO : level;
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                this.logger.log(logLevel, msgStr, (Throwable)param[param.length - 1]);
            } else {
                this.logger.log(logLevel, msgStr);
            }
            messageLogged = true;
        }
        if (DhLogger.canLogThisLevel(this.chatLevel.level, DhLogger.globalMaxChatLevel.level, level)) {
            if (mc_client == null) {
                mc_client = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
            }
            if (mc_client != null) {
                this.logToChat(level, msgStr);
                messageLogged = true;
            }
        }
        if (messageLogged) {
            this.logCountsThisSecondRef.incrementAndGet();
        }
    }

    private static boolean canLogThisLevel(Level thisLoggingLevel, Level thisGlobalLoggingLevel, Level requestedLogLevel) {
        return thisLoggingLevel.intLevel() >= requestedLogLevel.intLevel() && thisGlobalLoggingLevel.intLevel() >= requestedLogLevel.intLevel();
    }

    private static boolean loggingLevelIsLessSpecificThan(Level thisLoggingLevel, Level requestedLogLevel) {
        return thisLoggingLevel.intLevel() >= requestedLogLevel.intLevel();
    }

    private void logToChat(Level logLevel, String message) {
        String prefix = "[Distant Horizons] ";
        prefix = logLevel == Level.ERROR ? prefix + (Object)((Object)EMinecraftColor.DARK_RED) : (logLevel == Level.WARN ? prefix + (Object)((Object)EMinecraftColor.ORANGE) : (logLevel == Level.INFO ? prefix + (Object)((Object)EMinecraftColor.AQUA) : (logLevel == Level.DEBUG ? prefix + (Object)((Object)EMinecraftColor.GREEN) : (logLevel == Level.TRACE ? prefix + (Object)((Object)EMinecraftColor.DARK_GRAY) : prefix + (Object)((Object)EMinecraftColor.WHITE)))));
        prefix = prefix + (Object)((Object)EMinecraftColor.BOLD) + "" + (Object)((Object)EMinecraftColor.WHITE);
        prefix = prefix + logLevel.name();
        prefix = prefix + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + " ";
        mc_client.sendChatMessage(prefix + message);
    }

    private static void runTickerLoop() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    LOGGER_REF_LIST.removeIf(logger -> {
                        boolean loggerGarbageCollected;
                        boolean bl = loggerGarbageCollected = logger.get() == null;
                        if (loggerGarbageCollected) {
                            LOGGER.warn("Logger garbage collected. Loggers should only be created in static contexts otherwise memory leaks may occur.");
                        }
                        return loggerGarbageCollected;
                    });
                    LOGGER_REF_LIST.forEach(loggerRef -> {
                        DhLogger logger = (DhLogger)loggerRef.get();
                        if (logger != null) {
                            logger.logCountsThisSecondRef.set(0);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in ticker thread: [" + e.getMessage() + "].", (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        TICKER_THREAD.execute(() -> DhLogger.runTickerLoop());
    }
}

