/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import java.util.HashMap;
import java.util.Map;

public class NumberUtil {
    public static Map<Class<?>, Number> minValues = new HashMap<Class<?>, Number>(){
        {
            this.put(Byte.class, (byte)-128);
            this.put(Short.class, (short)Short.MIN_VALUE);
            this.put(Integer.class, Integer.MIN_VALUE);
            this.put(Long.class, Long.MIN_VALUE);
            this.put(Double.class, Double.MIN_VALUE);
            this.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        }
    };
    public static Map<Class<?>, Number> maxValues = new HashMap<Class<?>, Number>(){
        {
            this.put(Byte.class, (byte)127);
            this.put(Short.class, (short)Short.MAX_VALUE);
            this.put(Integer.class, Integer.MAX_VALUE);
            this.put(Long.class, Long.MAX_VALUE);
            this.put(Double.class, Double.MAX_VALUE);
            this.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        }
    };

    public static Number getMinimum(Class<?> c) {
        return minValues.get(c);
    }

    public static Number getMaximum(Class<?> c) {
        return maxValues.get(c);
    }

    public static boolean greaterThan(Number a, Number b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        Class<?> typeClass = a.getClass();
        if (typeClass == Byte.class) {
            return a.byteValue() > b.byteValue();
        }
        if (typeClass == Short.class) {
            return a.shortValue() > b.shortValue();
        }
        if (typeClass == Integer.class) {
            return a.intValue() > b.intValue();
        }
        if (typeClass == Long.class) {
            return a.longValue() > b.longValue();
        }
        if (typeClass == Double.class) {
            return a.doubleValue() > b.doubleValue();
        }
        if (typeClass == Float.class) {
            return a.floatValue() > b.floatValue();
        }
        return false;
    }

    public static boolean lessThan(Number a, Number b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        Class<?> typeClass = a.getClass();
        if (typeClass == Byte.class) {
            return a.byteValue() < b.byteValue();
        }
        if (typeClass == Short.class) {
            return a.shortValue() < b.shortValue();
        }
        if (typeClass == Integer.class) {
            return a.intValue() < b.intValue();
        }
        if (typeClass == Long.class) {
            return a.longValue() < b.longValue();
        }
        if (typeClass == Double.class) {
            return a.doubleValue() < b.doubleValue();
        }
        if (typeClass == Float.class) {
            return a.floatValue() < b.floatValue();
        }
        return false;
    }
}

