/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.TickRateManager;

public class ServerModule
extends BaseModule {
    public ServerModule() {
        this.defaultNameColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY);
        this.defaultValueColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("server_tick", "format.betterf3.server_tick", true));
        this.lines.add(new DebugLine("packets_sent"));
        this.lines.add(new DebugLine("packets_received"));
        this.lines.add(new DebugLine("tick_manager_status"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        IntegratedServer integratedServer = client.getSingleplayerServer();
        String serverString = "";
        if (integratedServer != null) {
            serverString = I18n.get((String)"text.betterf3.line.integrated_server", (Object[])new Object[0]);
        } else if (client.player != null) {
            serverString = Objects.requireNonNull(client.getConnection()).serverBrand();
        }
        if (client.getConnection() != null) {
            Connection clientConnection = client.getConnection().getConnection();
            float packetsSent = clientConnection.getAverageSentPackets();
            float packetsReceived = clientConnection.getAverageReceivedPackets();
            ((DebugLine)this.lines.get(1)).value(Math.round(packetsSent));
            ((DebugLine)this.lines.get(2)).value(Math.round(packetsReceived));
        }
        String tickString = "";
        if (integratedServer != null) {
            tickString = Integer.toString(Math.round(integratedServer.getCurrentSmoothedTickTime()));
        }
        LinkedList<MutableComponent> serverStringList = new LinkedList<MutableComponent>(Arrays.asList(Utils.styledText(serverString, this.nameColor), Utils.styledText(tickString, this.nameColor)));
        if (tickString.isEmpty()) {
            ((DebugLine)this.lines.get(0)).format("format.betterf3.no_format");
            serverStringList.remove(1);
        }
        ((DebugLine)this.lines.get(0)).value(serverStringList);
        String tickManagerStatus = I18n.get((String)"text.betterf3.line.tick_manager_status.normal", (Object[])new Object[0]);
        if (client.level != null) {
            TickRateManager tickratemanager = client.level.tickRateManager();
            if (integratedServer != null && integratedServer.tickRateManager().isSprinting()) {
                tickManagerStatus = I18n.get((String)"text.betterf3.line.tick_manager_status.sprinting", (Object[])new Object[0]);
            } else if (tickratemanager.isSteppingForward()) {
                tickManagerStatus = I18n.get((String)"text.betterf3.line.tick_manager_status.stepping", (Object[])new Object[0]);
            } else if (tickratemanager.isFrozen()) {
                tickManagerStatus = I18n.get((String)"text.betterf3.line.tick_manager_status.frozen", (Object[])new Object[0]);
            }
            ((DebugLine)this.lines.get(3)).value(tickManagerStatus);
        } else {
            ((DebugLine)this.lines.get((int)3)).active = false;
        }
    }
}

