/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.config;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerConfig {
    @Generated
    private static final Logger log = LogManager.getLogger(ServerConfig.class);
    @NotNull
    private final ModConfigSpec configSpec;
    @NotNull
    private final ModConfigSpec.IntValue sleepPercent;
    @NotNull
    private final ModConfigSpec.ConfigValue<List<? extends String>> sleepMessages;
    @NotNull
    private final ModConfigSpec.ConfigValue<List<? extends String>> wakeMessages;
    @NotNull
    private final ModConfigSpec.ConfigValue<List<? extends String>> morningMessages;
    @NotNull
    private final ModConfigSpec.BooleanValue allPlayersRest;
    @NotNull
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionsConfig;
    @NotNull
    private final ModConfigSpec.EnumValue<DimensionListType> dimensionListType;
    @NotNull
    private final ModConfigSpec.ConfigValue<List<? extends String>> blockBlacklistConfig;
    @NotNull
    private final TreeSet<ResourceKey<Level>> dimensions = new TreeSet<ResourceKey>(Comparator.comparing(ResourceKey::location));
    @NotNull
    private final TreeSet<ResourceLocation> blockBlacklist = new TreeSet();

    public ServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Percentage of players required to skip the night.");
        this.sleepPercent = builder.defineInRange("sleep_percent", 50, 0, 100);
        builder.comment(new String[]{"List of messages, from which one will be shown, when a player goes to bed", "(Available parameters: %player% = Player name)"});
        this.sleepMessages = builder.defineListAllowEmpty(List.of("sleep_messages"), () -> this.defaultSleepingMessages(), () -> "", obj -> obj instanceof String);
        builder.comment(new String[]{"List of messages, from which one will be shown, when a player leaves his bed", "(Available parameters: %player% = Player name)"});
        this.wakeMessages = builder.defineListAllowEmpty(List.of("wake_messages"), () -> this.defaultWakeMessages(), () -> "", obj -> obj instanceof String);
        builder.comment("List of messages, from which one will be shown, when the night was skipped");
        this.morningMessages = builder.defineListAllowEmpty(List.of("morning_messages"), () -> this.defaultMorningMessages(), () -> "", obj -> obj instanceof String);
        builder.comment("If true, the time since last rest is reset for all players, if enough other players are successfully sleeping. So not every player has to sleep to prevent phantom spawning for him.");
        this.allPlayersRest = builder.define("all_players_rest", false);
        builder.comment(new String[]{"If dimension_list_type is set to SLEEP_ACTIVE, the list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the list is the list of dimensions in which the sleep voting is inactive."});
        this.dimensionsConfig = builder.defineListAllowEmpty(List.of("dimensions"), () -> Collections.singletonList(Objects.requireNonNull(Level.OVERWORLD.location()).toString()), () -> "", obj -> obj instanceof String);
        builder.comment(new String[]{"If dimension_list_type is set to SLEEP_ACTIVE, the dimension list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the dimension list is the list of dimensions in which the sleep voting is inactive."});
        this.dimensionListType = builder.defineEnum("dimension_list_type", (Enum)DimensionListType.SLEEP_ACTIVE);
        builder.comment("Block names of beds being ignored for sleep percentage.");
        this.blockBlacklistConfig = builder.defineListAllowEmpty(List.of("block_blacklist"), () -> List.of(), () -> "", obj -> obj instanceof String);
        this.configSpec = builder.build();
    }

    private List<String> defaultSleepingMessages() {
        return List.of("%player% is now in bed.");
    }

    private List<String> defaultWakeMessages() {
        return List.of("%player% stood up.");
    }

    private List<String> defaultMorningMessages() {
        return List.of("Good Morning");
    }

    public void onServerStarting() {
        this.checkConfig();
    }

    private synchronized void checkConfig() {
        boolean areDimensionCorrected = this.checkCorrectAndReadDimensions();
        boolean areBlocksOfBlacklistCorrected = this.checkCorrectAndReadBlockBlacklist();
        if (areDimensionCorrected || areBlocksOfBlacklistCorrected) {
            log.info("\"{}\" Server Config corrected", (Object)"easier_sleeping");
        }
    }

    private synchronized boolean checkCorrectAndReadDimensions() {
        ArrayList<String> read_dimensions = new ArrayList<String>(this.getDimensionsValue());
        this.dimensions.clear();
        for (String read_dimension : read_dimensions) {
            ResourceLocation registry_name = ResourceLocation.tryParse((String)read_dimension);
            if (registry_name != null) {
                ResourceKey registrykey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)registry_name);
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().getLevel(registrykey);
                if (serverLevel == null) {
                    log.warn("Removed unknown dimension: {}", (Object)read_dimension);
                    continue;
                }
                this.dimensions.add((ResourceKey<Level>)registrykey);
                continue;
            }
            log.warn("Removed invalid dimension registry name {}", (Object)read_dimension);
        }
        if (this.getDimensionsValue().size() != this.dimensions.size()) {
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
            return true;
        }
        return false;
    }

    @NotNull
    private synchronized ArrayList<String> dimensionsToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceKey<Level> dimension : this.dimensions) {
            registryNames.add(Objects.requireNonNull(dimension.location()).toString());
        }
        return registryNames;
    }

    public synchronized void invertDimensions() {
        ArrayList<String> newDimensionRegistryNames = new ArrayList<String>();
        for (ServerLevel serverLevel : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
            ResourceKey registrykey = serverLevel.dimension();
            if (this.dimensions.contains(registrykey)) continue;
            newDimensionRegistryNames.add(Objects.requireNonNull(registrykey.location()).toString());
        }
        newDimensionRegistryNames.sort(String::compareTo);
        this.setDimensionsValue(newDimensionRegistryNames);
        this.checkConfig();
    }

    private synchronized boolean checkCorrectAndReadBlockBlacklist() {
        ArrayList<String> block_blacklist = new ArrayList<String>(this.getBlockBlacklist());
        this.blockBlacklist.clear();
        for (String block : block_blacklist) {
            ResourceLocation registry_name = ResourceLocation.tryParse((String)block);
            if (registry_name != null) {
                if (BuiltInRegistries.BLOCK.getOptional(registry_name).isPresent()) {
                    this.blockBlacklist.add(registry_name);
                    continue;
                }
                log.warn("Removed unknown block: {}", (Object)block);
                continue;
            }
            log.warn("Removed invalid block registry name {}", (Object)block);
        }
        if (this.getBlockBlacklist().size() != this.blockBlacklist.size()) {
            this.setBlockBlacklist(this.blockBlacklistToRegistryNameList());
            return true;
        }
        return false;
    }

    @NotNull
    private synchronized ArrayList<String> blockBlacklistToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceLocation block : this.blockBlacklist) {
            registryNames.add(Objects.requireNonNull(block).toString());
        }
        return registryNames;
    }

    public int getSleepPercent() {
        return (Integer)this.sleepPercent.get();
    }

    public void setSleepPercent(int sleep_percent) {
        this.sleepPercent.set((Object)sleep_percent);
    }

    @NotNull
    public List<String> getSleepMessages() {
        return new ArrayList<String>((List)this.sleepMessages.get());
    }

    @NotNull
    public List<String> getSleepMessagesOrDefault() {
        List<String> messages = this.getSleepMessages();
        if (messages.isEmpty()) {
            return this.defaultSleepingMessages();
        }
        return messages;
    }

    private List<String> distinctMessages(List<String> messages) {
        return messages.stream().distinct().collect(Collectors.toList());
    }

    public void setSleepMessages(@NotNull List<String> messages) {
        this.sleepMessages.set(this.distinctMessages(messages));
    }

    @NotNull
    public List<String> getWakeMessages() {
        return new ArrayList<String>((List)this.wakeMessages.get());
    }

    @NotNull
    public List<String> getWakeMessagesOrDefault() {
        List<String> messages = this.getWakeMessages();
        if (messages.isEmpty()) {
            return this.defaultWakeMessages();
        }
        return messages;
    }

    public void setWakeMessages(@NotNull List<String> messages) {
        this.wakeMessages.set(this.distinctMessages(messages));
    }

    @NotNull
    public List<String> getMorningMessages() {
        return new ArrayList<String>((List)this.morningMessages.get());
    }

    @NotNull
    public List<String> getMorningMessagesOrDefault() {
        List<String> messages = this.getMorningMessages();
        if (messages.isEmpty()) {
            return this.defaultMorningMessages();
        }
        return messages;
    }

    public void setMorningMessages(@NotNull List<String> messages) {
        this.morningMessages.set(this.distinctMessages(messages));
    }

    public boolean getAllPlayersRest() {
        return (Boolean)this.allPlayersRest.get();
    }

    public void setAllPlayersRest(boolean all_player_rest) {
        this.allPlayersRest.set((Object)all_player_rest);
    }

    @NotNull
    private List<String> getDimensionsValue() {
        return new ArrayList<String>((List)this.dimensionsConfig.get());
    }

    private void setDimensionsValue(@NotNull List<String> dimensionsValue) {
        this.dimensionsConfig.set(dimensionsValue);
    }

    @NotNull
    public TreeSet<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public synchronized void addDimension(@NotNull ResourceKey<Level> dimension) {
        if (!this.dimensions.contains(dimension)) {
            this.dimensions.add(dimension);
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
        }
    }

    public synchronized void removeDimension(@NotNull ResourceKey<Level> dimension) {
        if (this.dimensions.contains(dimension)) {
            this.dimensions.remove(dimension);
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
        }
    }

    @NotNull
    public DimensionListType getDimensionListType() {
        return (DimensionListType)((Object)this.dimensionListType.get());
    }

    public void setDimensionListType(@NotNull DimensionListType _dimensionListType) {
        this.dimensionListType.set((Object)_dimensionListType);
    }

    @NotNull
    private List<String> getBlockBlacklist() {
        return new ArrayList<String>((List)this.blockBlacklistConfig.get());
    }

    private void setBlockBlacklist(@NotNull List<String> _blockBlacklist) {
        this.blockBlacklistConfig.set(_blockBlacklist);
    }

    @NotNull
    public TreeSet<ResourceLocation> getIgnoredBedBlocks() {
        return this.blockBlacklist;
    }

    @NotNull
    @Generated
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }
}

