/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.elements.commands.sleep;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import de.geheimagentnr1.easier_sleeping.elements.commands.sleep.MessageActionType;
import de.geheimagentnr1.easier_sleeping.elements.commands.sleep.dimension_list_type.DimensionListTypeArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SleepCommand {
    @NotNull
    private final ServerConfig serverConfig;

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder sleep = (LiteralArgumentBuilder)Commands.literal((String)"sleep").requires(source -> source.hasPermission(2));
        sleep.then(((LiteralArgumentBuilder)Commands.literal((String)"sleep_percent").executes(this::showSleepPercent)).then(Commands.argument((String)"sleep_percent", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::changeSleepPercent)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"messages").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wake").executes(this::showWakeMessage)).then(Commands.literal((String)"add").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::addWakeMessage)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::removeWakeMessage))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sleep").executes(this::showSleepMessage)).then(Commands.literal((String)"add").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::addSleepMessage)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::removeSleepMessage))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"morning").executes(this::showMorningMessage)).then(Commands.literal((String)"add").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::addMorningMessage)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(this::removeMorningMessage)))));
        sleep.then(((LiteralArgumentBuilder)Commands.literal((String)"all_players_rest").executes(this::showAllPlayersRest)).then(Commands.argument((String)"all_players_rest", (ArgumentType)BoolArgumentType.bool()).executes(this::setAllPlayersRest)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dimension").executes(this::showDimensions)).then(Commands.literal((String)"add").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(this::addDimension)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(this::removeDimension)))).then(((LiteralArgumentBuilder)Commands.literal((String)"list_type").executes(this::showDimensionListType)).then(Commands.argument((String)"list_type", (ArgumentType)DimensionListTypeArgument.dimensionListType()).then(Commands.argument((String)"invert_list", (ArgumentType)BoolArgumentType.bool()).executes(this::changeDimensionListType)))));
        return sleep;
    }

    private int showSleepPercent(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("Sleep Percent: %d", this.serverConfig.getSleepPercent())), false);
        return 1;
    }

    private int changeSleepPercent(@NotNull CommandContext<CommandSourceStack> context) {
        this.serverConfig.setSleepPercent(IntegerArgumentType.getInteger(context, (String)"sleep_percent"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("Sleep Percent is now: %d", this.serverConfig.getSleepPercent())), true);
        return 1;
    }

    private void sendMessages(@NotNull CommandContext<CommandSourceStack> context, @NotNull String messagePrefix, @NotNull Supplier<List<String>> configMessagesGetter) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("%s: %s", messagePrefix, String.join((CharSequence)", ", (Iterable)configMessagesGetter.get()))), true);
    }

    private int showMessages(@NotNull CommandContext<CommandSourceStack> context, @NotNull String resultMessagePrefix, @NotNull Supplier<List<String>> configMessagesGetter) {
        this.sendMessages(context, String.format("%s Messages", resultMessagePrefix), configMessagesGetter);
        return 1;
    }

    private int showWakeMessage(@NotNull CommandContext<CommandSourceStack> context) {
        return this.showMessages(context, "Wake", this.serverConfig::getWakeMessages);
    }

    private int changeMessages(@NotNull CommandContext<CommandSourceStack> context, @NotNull MessageActionType messageActionType, @NotNull Consumer<List<String>> configMessagesSetter, @NotNull Supplier<List<String>> configMessagesGetter, @NotNull String resultMessagePrefix) throws CommandSyntaxException {
        String message = MessageArgument.getMessage(context, (String)"message").getString();
        ArrayList<String> messages = new ArrayList<String>((Collection)configMessagesGetter.get());
        if (messageActionType == MessageActionType.ADD) {
            messages.add(message);
        } else {
            messages.remove(message);
        }
        configMessagesSetter.accept(messages);
        this.sendMessages(context, String.format("%s Messages are now", resultMessagePrefix), configMessagesGetter);
        return 1;
    }

    private int changeWakeMessage(@NotNull CommandContext<CommandSourceStack> context, @NotNull MessageActionType messageActionType) throws CommandSyntaxException {
        return this.changeMessages(context, messageActionType, this.serverConfig::setWakeMessages, this.serverConfig::getWakeMessages, "Wake");
    }

    private int addWakeMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeWakeMessage(context, MessageActionType.ADD);
    }

    private int removeWakeMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeWakeMessage(context, MessageActionType.REMOVE);
    }

    private int showSleepMessage(@NotNull CommandContext<CommandSourceStack> context) {
        return this.showMessages(context, "Sleep", this.serverConfig::getSleepMessages);
    }

    private int changeSleepMessage(@NotNull CommandContext<CommandSourceStack> context, @NotNull MessageActionType messageActionType) throws CommandSyntaxException {
        return this.changeMessages(context, messageActionType, this.serverConfig::setSleepMessages, this.serverConfig::getSleepMessages, "Sleep");
    }

    private int addSleepMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeSleepMessage(context, MessageActionType.ADD);
    }

    private int removeSleepMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeSleepMessage(context, MessageActionType.REMOVE);
    }

    private int showMorningMessage(@NotNull CommandContext<CommandSourceStack> context) {
        return this.showMessages(context, "Morning", this.serverConfig::getMorningMessages);
    }

    private int changeMorningMessage(@NotNull CommandContext<CommandSourceStack> context, @NotNull MessageActionType messageActionType) throws CommandSyntaxException {
        return this.changeMessages(context, messageActionType, this.serverConfig::setMorningMessages, this.serverConfig::getMorningMessages, "Morning");
    }

    private int addMorningMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeMorningMessage(context, MessageActionType.ADD);
    }

    private int removeMorningMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.changeMorningMessage(context, MessageActionType.REMOVE);
    }

    private int showAllPlayersRest(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("All players rest is: %s", this.serverConfig.getAllPlayersRest())), true);
        return 1;
    }

    private int setAllPlayersRest(@NotNull CommandContext<CommandSourceStack> context) {
        this.serverConfig.setAllPlayersRest(BoolArgumentType.getBool(context, (String)"all_players_rest"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("All players rest is now : %s", this.serverConfig.getAllPlayersRest())), true);
        return 1;
    }

    private int showDimensions(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : this.serverConfig.getDimensions()) {
            source.sendSuccess(() -> Component.literal((String)String.format(" - %s", dimension.location())), false);
        }
        return 1;
    }

    private int addDimension(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        this.serverConfig.addDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("Added Dimension: %s", dimension.location())), true);
        return 1;
    }

    private int removeDimension(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        this.serverConfig.removeDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("Removed Dimension: %s", dimension.location())), true);
        return 1;
    }

    private int showDimensionListType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)String.format("Dimension List Type: %s", this.serverConfig.getDimensionListType().name())), false);
        return 1;
    }

    private int changeDimensionListType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        DimensionListType dimensionListType = DimensionListTypeArgument.getDimensionListType(context, "list_type");
        boolean revert = BoolArgumentType.getBool(context, (String)"invert_list");
        this.serverConfig.setDimensionListType(dimensionListType);
        if (revert) {
            this.serverConfig.invertDimensions();
        }
        source.sendSuccess(() -> Component.literal((String)String.format("Dimension List Type set to: %s", this.serverConfig.getDimensionListType().name())), false);
        source.sendSuccess(() -> Component.literal((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : this.serverConfig.getDimensions()) {
            source.sendSuccess(() -> Component.literal((String)String.format(" - %s", dimension.location())), false);
        }
        return 1;
    }

    @Generated
    public SleepCommand(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

