/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.elements.commands.sleep.dimension_list_type;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

class DimensionListTypeParser {
    @NotNull
    private static final DynamicCommandExceptionType DIMENSION_LIST_TYPE_INVALID = new DynamicCommandExceptionType(function -> Component.literal((String)"Invalid Dimension List Type"));
    @NotNull
    private static final Set<String> DIMENSION_LIST_TYPES = DimensionListTypeParser.getItemKeySet();
    @NotNull
    private final StringReader reader;
    private DimensionListType dimensionListType;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder;

    DimensionListTypeParser(@NotNull StringReader _reader) {
        this.reader = _reader;
    }

    @NotNull
    private static Set<String> getItemKeySet() {
        TreeSet<String> keySet = new TreeSet<String>();
        for (DimensionListType dimensionListType : DimensionListType.values()) {
            keySet.add(dimensionListType.name());
        }
        return keySet;
    }

    @NotNull
    DimensionListType getDimensionListType() {
        return this.dimensionListType;
    }

    private void readDimensionListType() throws CommandSyntaxException {
        int cursor = this.reader.getCursor();
        while (this.reader.canRead() && this.reader.peek() != ' ') {
            this.reader.skip();
        }
        String dimensionListTypeString = this.reader.getString().substring(cursor, this.reader.getCursor());
        this.dimensionListType = this.getItemForRegistry(dimensionListTypeString).orElseThrow(() -> {
            this.reader.setCursor(cursor);
            return DIMENSION_LIST_TYPE_INVALID.createWithContext((ImmutableStringReader)this.reader, (Object)dimensionListTypeString);
        });
    }

    @NotNull
    private Optional<DimensionListType> getItemForRegistry(@NotNull String dimensionListTypeString) {
        for (DimensionListType forDimensionListType : DimensionListType.values()) {
            if (!forDimensionListType.name().equals(dimensionListTypeString)) continue;
            return Optional.of(forDimensionListType);
        }
        return Optional.empty();
    }

    @NotNull
    DimensionListTypeParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestDimensionListType;
        this.readDimensionListType();
        this.suggestionsBuilder = this::suggestDimensionListTypeFuture;
        return this;
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestDimensionListTypeFuture(@NotNull SuggestionsBuilder builder) {
        return builder.buildFuture();
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestDimensionListType(@NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(DIMENSION_LIST_TYPES, (SuggestionsBuilder)builder);
    }

    @NotNull
    CompletableFuture<Suggestions> fillSuggestions(@NotNull SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }
}

