/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.sleeping;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;

public class SleepingManager {
    @NotNull
    private static final Comparator<Player> PLAYER_COMPARATOR = Comparator.comparing(Entity::getUUID);
    @NotNull
    private final ServerConfig serverConfig;
    private TreeMap<ResourceKey<Level>, TreeSet<ServerPlayer>> SLEEPING;

    private void init() {
        this.SLEEPING = new TreeMap(Comparator.comparing(ResourceKey::location));
    }

    void updateSleepingPlayers(@NotNull MinecraftServer server) {
        for (ServerLevel level : server.getAllLevels()) {
            ResourceKey registrykey = level.dimension();
            boolean containsDimension = this.serverConfig.getDimensions().contains(registrykey);
            if (this.serverConfig.getDimensionListType() == DimensionListType.SLEEP_ACTIVE && !containsDimension || this.serverConfig.getDimensionListType() == DimensionListType.SLEEP_INACTIVE && containsDimension) continue;
            if (!this.SLEEPING.containsKey(registrykey)) {
                this.SLEEPING.put((ResourceKey<Level>)registrykey, new TreeSet<Player>(PLAYER_COMPARATOR));
            }
            TreeSet<ServerPlayer> sleeping_players = this.SLEEPING.get(registrykey);
            List level_players = level.players();
            int non_spectator_player_count = this.countNonSpectatorPlayers(level_players);
            for (ServerPlayer player2 : level_players) {
                if (player2.isSleeping() && !sleeping_players.contains(player2)) {
                    if (!player2.getSleepingPos().stream().noneMatch(pos -> this.serverConfig.getIgnoredBedBlocks().contains(BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(pos).getBlock())))) continue;
                    sleeping_players.add(player2);
                    this.sendSleepMessage(level, level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
                    continue;
                }
                if (player2.isSleeping() || !sleeping_players.contains(player2)) continue;
                sleeping_players.remove(player2);
                this.sendWakeMessage(level, level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
            }
            int sleeping_percent = this.caculateSleepingPercent(this.countSleepingPlayers(sleeping_players), non_spectator_player_count);
            if (sleeping_percent < this.serverConfig.getSleepPercent()) continue;
            if (level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                long currentDayTime = level.getDayTime();
                long newDayTime = currentDayTime + 24000L - currentDayTime % 24000L;
                newDayTime = EventHooks.onSleepFinished((ServerLevel)level, (long)newDayTime, (long)currentDayTime);
                level.setDayTime(newDayTime);
            }
            sleeping_players.forEach(player -> {
                player.getSleepingPos().ifPresent(pos -> player.setRespawnPosition(level.dimension(), pos, player.getYRot(), false, false));
                player.stopSleepInBed(false, false);
            });
            if (level.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                level.setWeatherParameters(0, 0, false, false);
            }
            if (this.serverConfig.getAllPlayersRest()) {
                level_players.forEach(player -> player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)));
            }
            this.sendMorningMessage(level, level_players);
            sleeping_players.clear();
        }
    }

    private int countNonSpectatorPlayers(@NotNull List<? extends Player> players) {
        int count = 0;
        for (Player player : players) {
            if (player.isSpectator()) continue;
            ++count;
        }
        return count;
    }

    private int countSleepingPlayers(@NotNull TreeSet<ServerPlayer> players) {
        int count = 0;
        for (ServerPlayer player : players) {
            if (!player.isSleeping() || player.getSleepTimer() < 80) continue;
            ++count;
        }
        return count;
    }

    private String getRandomMessage(@NotNull ServerLevel level, @NotNull List<String> messages) {
        int messageIndex = Math.abs(level.getRandom().nextInt()) % messages.size();
        return messages.get(messageIndex);
    }

    private void sendWakeMessage(@NotNull ServerLevel level, @NotNull List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, @NotNull Player wake_player) {
        this.sendMessage(players, this.buildWakeSleepMessage(wake_player, sleep_player_count, non_spectator_player_count, this.getRandomMessage(level, this.serverConfig.getWakeMessagesOrDefault())));
    }

    private void sendSleepMessage(@NotNull ServerLevel level, @NotNull List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, @NotNull Player sleep_player) {
        this.sendMessage(players, this.buildWakeSleepMessage(sleep_player, sleep_player_count, non_spectator_player_count, this.getRandomMessage(level, this.serverConfig.getSleepMessagesOrDefault())));
    }

    private void sendMorningMessage(@NotNull ServerLevel level, @NotNull List<? extends Player> players) {
        this.sendMessage(players, Component.literal((String)this.getRandomMessage(level, this.serverConfig.getMorningMessagesOrDefault())));
    }

    private void sendMessage(@NotNull List<? extends Player> players, @NotNull MutableComponent message) {
        for (Player player : players) {
            player.sendSystemMessage((Component)message.setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY))));
        }
    }

    @NotNull
    private MutableComponent buildWakeSleepMessage(@NotNull Player player, int sleep_player_count, int player_count, @NotNull String message) {
        return Component.literal((String)String.format(" %s - %d/%d (%d%%)", this.replaceParameters(message, Map.of("player", player.getDisplayName().getString())), sleep_player_count, player_count, this.caculateSleepingPercent(sleep_player_count, player_count)));
    }

    @NotNull
    private String replaceParameters(@NotNull String message, @NotNull Map<String, String> parameters) {
        String result = message;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result = result.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return result;
    }

    private int caculateSleepingPercent(int sleep_player_count, int non_spectator_player_count) {
        return non_spectator_player_count == 0 ? 0 : sleep_player_count * 100 / non_spectator_player_count;
    }

    @SubscribeEvent
    public void handleServerStartingEvent(@NotNull ServerStartingEvent event) {
        this.init();
        this.serverConfig.onServerStarting();
    }

    @SubscribeEvent
    public void handleServerTickEvent(@NotNull ServerTickEvent.Post event) {
        if (this.SLEEPING != null && event.getServer().getTickCount() % 20 == 0) {
            this.updateSleepingPlayers(event.getServer());
        }
    }

    @Generated
    public SleepingManager(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

