/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.doubledoors_common_neoforge.config.ConfigHandler;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class Util {
    public static boolean isDoorBlock(BlockState blockState) {
        return Util.isDoorBlock(blockState.getBlock());
    }

    public static boolean isDoorBlock(Block block) {
        return block instanceof DoorBlock && ConfigHandler.enableDoors || block instanceof TrapDoorBlock && ConfigHandler.enableTrapdoors || block instanceof FenceGateBlock && ConfigHandler.enableFenceGates;
    }

    public static boolean isPressureBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof WeightedPressurePlateBlock) {
            return (Integer)blockState.getValue((Property)BlockStateProperties.POWER) > 0;
        }
        if (block instanceof PressurePlateBlock || block instanceof ButtonBlock) {
            return (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED);
        }
        return false;
    }

    public static boolean processDoor(Player player, Level level, BlockPos blockPos, BlockState blockState, Boolean isOpen) {
        List<BlockPos> posToOpenList;
        Block block = blockState.getBlock();
        if (block instanceof DoorBlock && ((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            blockPos = blockPos.below().immutable();
            blockState = level.getBlockState(blockPos);
        }
        if (!blockState.hasProperty((Property)BlockStateProperties.OPEN)) {
            return false;
        }
        if (isOpen == null) {
            isOpen = (Boolean)blockState.getValue((Property)BlockStateProperties.OPEN);
        }
        Direction facing = null;
        if (block instanceof FenceGateBlock) {
            facing = (Direction)blockState.getValue((Property)FenceGateBlock.FACING);
        }
        int yOffset = 0;
        if (!(block instanceof DoorBlock)) {
            yOffset = 1;
        }
        if ((posToOpenList = Util.recursivelyOpenDoors(new ArrayList<BlockPos>(Arrays.asList(blockPos.immutable())), new ArrayList<BlockPos>(), level, blockPos, blockPos, block, yOffset)).size() <= 1) {
            return false;
        }
        for (BlockPos toOpenBlockPos : posToOpenList) {
            Direction oFacing;
            if (toOpenBlockPos.equals((Object)blockPos)) continue;
            BlockState oBlockState = level.getBlockState(toOpenBlockPos);
            Block oBlock = oBlockState.getBlock();
            if (block instanceof DoorBlock) {
                if (!ConfigHandler.enableDoors) continue;
                level.setBlock(toOpenBlockPos, (BlockState)oBlockState.setValue((Property)DoorBlock.OPEN, (Comparable)isOpen), 10);
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                if (!ConfigHandler.enableTrapdoors) continue;
                level.setBlock(toOpenBlockPos, (BlockState)oBlockState.setValue((Property)BlockStateProperties.OPEN, (Comparable)isOpen), 10);
                continue;
            }
            if (!(block instanceof FenceGateBlock) || !ConfigHandler.enableFenceGates || !(oFacing = (Direction)oBlockState.getValue((Property)FenceGateBlock.FACING)).equals((Object)facing) && !oFacing.getOpposite().equals((Object)facing)) continue;
            level.setBlock(toOpenBlockPos, (BlockState)((BlockState)oBlockState.setValue((Property)DoorBlock.OPEN, (Comparable)isOpen)).setValue((Property)FenceGateBlock.FACING, (Comparable)facing), 10);
        }
        if (player != null) {
            player.swing(InteractionHand.MAIN_HAND);
        }
        return posToOpenList.size() > 1;
    }

    private static List<BlockPos> recursivelyOpenDoors(List<BlockPos> posToOpenList, List<BlockPos> ignoreOpenList, Level level, BlockPos originalBlockPos, BlockPos blockPos, Block block, int yOffset) {
        Iterator blocksaround = BlockPos.betweenClosedStream((int)(blockPos.getX() - 1), (int)(blockPos.getY() - yOffset), (int)(blockPos.getZ() - 1), (int)(blockPos.getX() + 1), (int)(blockPos.getY() + yOffset), (int)(blockPos.getZ() + 1)).iterator();
        while (blocksaround.hasNext()) {
            BlockPos bpa = (BlockPos)blocksaround.next();
            if (posToOpenList.contains(bpa) || !BlockPosFunctions.withinDistance((BlockPos)originalBlockPos, (BlockPos)bpa, (int)ConfigHandler.recursiveOpeningMaxBlocksDistance).booleanValue()) continue;
            BlockState oBlockState = level.getBlockState(bpa);
            Block oBlock = oBlockState.getBlock();
            if (Util.isDoorBlock(oBlockState) && oBlock.getName().equals((Object)block.getName())) {
                posToOpenList.add(bpa.immutable());
                if (!ConfigHandler.enableRecursiveOpening) continue;
                Util.recursivelyOpenDoors(posToOpenList, ignoreOpenList, level, originalBlockPos, bpa, block, yOffset);
                continue;
            }
            ignoreOpenList.add(bpa.immutable());
        }
        return posToOpenList;
    }

    public static void checkForOtherModdedDoubleDoorFunctionality() {
        block17: {
            if (!ConfigHandler.enableModIncompatibilityCheck) {
                return;
            }
            try {
                if (!Services.MODLOADER.isModLoaded("quark")) break block17;
                String quarkConfigPath = DataFunctions.getConfigDirectory() + File.separator + "quark-common.toml";
                File quarkConfig = new File(quarkConfigPath);
                if (quarkConfig.exists()) {
                    List<String> doorConfigKeys = Arrays.asList("\"Double Door Opening\"", "\"Enable Doors\"", "\"Enable Fence Gates\"");
                    String quarkConfigContent = Files.readString(Path.of(quarkConfigPath, new String[0]), StandardCharsets.UTF_8);
                    boolean writeOutput = false;
                    StringBuilder output = new StringBuilder();
                    for (String line : quarkConfigContent.split("\n")) {
                        if (output.length() > 0) {
                            output.append("\n");
                        }
                        for (String doorConfigKey : doorConfigKeys) {
                            if (!line.contains(doorConfigKey) || !line.contains("true")) continue;
                            line = line.replace("true", "false");
                            writeOutput = true;
                            break;
                        }
                        output.append(line);
                    }
                    if (!writeOutput) break block17;
                    try (PrintWriter printWriter = new PrintWriter(quarkConfigPath);){
                        printWriter.println(output);
                        break block17;
                    }
                }
                String quarkConfigIfNewInstance = "[tweaks]\n\t\"Double Door Opening\" = false\n\n\t[tweaks.double_door_opening]\n\t\t\"Enable Doors\" = false\n\t\t\"Enable Fence Gates\" = false\n\t\t\"Ignore Anti Overlap\" = false";
                try (PrintWriter printWriter = new PrintWriter(quarkConfigPath);){
                    printWriter.println(quarkConfigIfNewInstance);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

