/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines;

import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import ru.magistu.siegemachines.PacketHandlerNeoForge;
import ru.magistu.siegemachines.SiegeMachines;
import ru.magistu.siegemachines.client.ClientProxyForge;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.datagen.ModDatagen;
import ru.magistu.siegemachines.entity.EntityDataSerializers;
import ru.magistu.siegemachines.entity.ModEntityTypes;
import ru.magistu.siegemachines.entity.machine.BatteringRam;
import ru.magistu.siegemachines.entity.machine.Cannon;
import ru.magistu.siegemachines.entity.machine.Catapult;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.SiegeLadder;
import ru.magistu.siegemachines.init.IngredientTypes;

@Mod(value="siegemachines")
public class SiegeMachinesNeoForge {
    public SiegeMachinesNeoForge(IEventBus bus, Dist dist, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SpecsConfig.SPEC, "siege-machines-specs.toml");
        bus.addListener(ModDatagen::gather);
        bus.addListener(SiegeMachinesNeoForge::addEntityAttributes);
        bus.addListener(PacketHandlerNeoForge::register);
        if (dist.isClient()) {
            ClientProxyForge.setup(bus);
        }
        IngredientTypes.register(bus);
        EntityDataSerializers.register(bus);
        SiegeMachines.init();
    }

    private static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntityTypes.MORTAR.get(), Cannon.setEntityAttributes(MachineType.MORTAR).build());
        event.put((EntityType)ModEntityTypes.CULVERIN.get(), Cannon.setEntityAttributes(MachineType.CULVERIN).build());
        event.put((EntityType)ModEntityTypes.TREBUCHET.get(), Catapult.setEntityAttributes(MachineType.TREBUCHET).build());
        event.put((EntityType)ModEntityTypes.CATAPULT.get(), Catapult.setEntityAttributes(MachineType.CATAPULT).build());
        event.put((EntityType)ModEntityTypes.BALLISTA.get(), Catapult.setEntityAttributes(MachineType.BALLISTA).build());
        event.put((EntityType)ModEntityTypes.BATTERING_RAM.get(), BatteringRam.setEntityAttributes(MachineType.BATTERING_RAM).build());
        event.put((EntityType)ModEntityTypes.SIEGE_LADDER.get(), SiegeLadder.setEntityAttributes(MachineType.SIEGE_LADDER).build());
    }
}

