/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import ru.magistu.siegemachines.config.MissileSpecs;
import ru.magistu.siegemachines.config.SiegeMachineSpecs;

public final class SpecsConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Double> FIRE_DAMAGE_MULTIPLIER;
    public static final ModConfigSpec.ConfigValue<Double> EXPLOSION_DAMAGE_MULTIPLIER;
    public static final ModConfigSpec.ConfigValue<Double> ARROW_DAMAGE_MULTIPLIER;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_FRIENDLY_FIRE;
    public static final ModConfigSpec.ConfigValue<Integer> DEPLOYMENT_SICKNESS_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Integer> PREVENT_PICKUP_COOLDOWN;
    public static final SiegeMachineSpecs MORTAR;
    public static final SiegeMachineSpecs CULVERIN;
    public static final SiegeMachineSpecs TREBUCHET;
    public static final SiegeMachineSpecs CATAPULT;
    public static final SiegeMachineSpecs BALLISTA;
    public static final SiegeMachineSpecs BATTERING_RAM;
    public static final SiegeMachineSpecs SIEGE_LADDER;
    public static final MissileSpecs CANNONBALL;
    public static final MissileSpecs STONE;
    public static final MissileSpecs GIANT_STONE;

    static {
        BUILDER.push("siege_machines");
        FIRE_DAMAGE_MULTIPLIER = BUILDER.define("fireDamageMultiplier", (Object)3.0);
        EXPLOSION_DAMAGE_MULTIPLIER = BUILDER.define("explosionDamageMultiplier", (Object)2.0);
        ARROW_DAMAGE_MULTIPLIER = BUILDER.define("arrowDamageMultiplier", (Object)0.5);
        ALLOW_FRIENDLY_FIRE = BUILDER.define("allowFriendlyFire", false);
        DEPLOYMENT_SICKNESS_COOLDOWN = BUILDER.define("deploymentSicknessCooldown", (Object)300);
        PREVENT_PICKUP_COOLDOWN = BUILDER.define("preventPickupCooldown", (Object)300);
        MORTAR = new SiegeMachineSpecs(BUILDER, "mortar", 80, 200, 2.5f, 0.2f, 0.5f);
        CULVERIN = new SiegeMachineSpecs(BUILDER, "culverin", 150, 260, 3.5f, 0.03f, 0.6f);
        TREBUCHET = new SiegeMachineSpecs(BUILDER, "trebuchet", 350, 400, 2.8f, 0.2f, 1.0f);
        CATAPULT = new SiegeMachineSpecs(BUILDER, "catapult", 150, 200, 2.0f, 0.2f, 0.8f);
        BALLISTA = new SiegeMachineSpecs(BUILDER, "ballista", 70, 120, 4.5f, 0.04f, 0.4f);
        BATTERING_RAM = new SiegeMachineSpecs(BUILDER, "battering_ram", 500, 100, 0.0f, 0.5f, 1.0f);
        SIEGE_LADDER = new SiegeMachineSpecs(BUILDER, "siege_ladder", 400, 0, 0.0f, 0.0f, 1.0f);
        BUILDER.pop();
        BUILDER.push("missiles");
        CANNONBALL = new MissileSpecs(BUILDER, "cannonball", 15.0, 3.0, 1.0, 1.5, 1.5, true, false);
        STONE = new MissileSpecs(BUILDER, "stone", 50.0, 2.5, 1.0, 1.5, 1.8, true, false);
        GIANT_STONE = new MissileSpecs(BUILDER, "giant_stone", 70.0, 5.0, 1.0, 3.0, 3.0, true, false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

