/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.gui;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import ru.magistu.siegemachines.item.recipes.ModRecipeSerializers;
import ru.magistu.siegemachines.item.recipes.SiegeWorkbenchRecipe;

public class SiegeWorkbenchResultSlot
extends Slot {
    private final CraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public SiegeWorkbenchResultSlot(Player player, CraftingContainer craftSlots, Container container, int slot, int xPosition, int yPosition) {
        super(container, slot, xPosition, yPosition);
        this.player = player;
        this.craftSlots = craftSlots;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int numItemsCrafted) {
        this.removeCount += numItemsCrafted;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        Container container;
        if (this.removeCount > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder recipecraftingholder = (RecipeCraftingHolder)container;
            recipecraftingholder.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        CraftingInput.Positioned positioned = this.craftSlots.asPositionedCraftInput();
        CraftingInput craftinginput = positioned.input();
        int i = positioned.left();
        int j = positioned.top();
        RecipeManager manager = player.level().getRecipeManager();
        NonNullList nonnulllist = manager.getRemainingItemsFor(ModRecipeSerializers.SIEGE_WORKBENCH_RECIPE, (RecipeInput)craftinginput, player.level());
        Optional recipe = manager.getRecipeFor(ModRecipeSerializers.SIEGE_WORKBENCH_RECIPE, (RecipeInput)craftinginput, player.level());
        if (recipe.isEmpty()) {
            return;
        }
        for (int k = 0; k < craftinginput.height(); ++k) {
            for (int l = 0; l < craftinginput.width(); ++l) {
                int i1 = l + i + (k + j) * this.craftSlots.getWidth();
                ItemStack itemstack = this.craftSlots.getItem(i1);
                ItemStack itemstack1 = (ItemStack)nonnulllist.get(l + k * craftinginput.width());
                Ingredient recipeElement = (Ingredient)((SiegeWorkbenchRecipe)((RecipeHolder)recipe.get()).value()).getIngredients().get(l + k * craftinginput.width());
                if (!itemstack.isEmpty() && recipeElement.getItems().length != 0) {
                    this.craftSlots.removeItem(i1, recipeElement.getItems()[0].getCount());
                    itemstack = this.craftSlots.getItem(i);
                }
                if (itemstack1.isEmpty()) continue;
                if (itemstack.isEmpty()) {
                    this.craftSlots.setItem(i1, itemstack1);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)itemstack1)) {
                    itemstack1.grow(itemstack.getCount());
                    this.craftSlots.setItem(i1, itemstack1);
                    continue;
                }
                if (this.player.getInventory().add(itemstack1)) continue;
                this.player.drop(itemstack1, false);
            }
        }
    }
}

