/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.menu.SiegeWorkbenchMenu;

public class SiegeWorkbenchScreen
extends AbstractContainerScreen<SiegeWorkbenchMenu> {
    private static final ResourceLocation DISPLAY_CASE_GUI = ResourceLocation.fromNamespaceAndPath((String)"siegemachines", (String)"textures/gui/siege_workbench.png");

    public SiegeWorkbenchScreen(SiegeWorkbenchMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (this.minecraft.player.getInventory().getSelected().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.minecraft.font, this.hoveredSlot.getItem(), x, y);
        }
    }

    protected void init() {
        super.init();
        this.titleLabelX = 29;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DISPLAY_CASE_GUI);
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(DISPLAY_CASE_GUI, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int key, int b, int c) {
        assert (this.minecraft != null);
        if (key == 256) {
            assert (this.minecraft.player != null);
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }
}

