/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.item;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.client.KeyBindings;
import ru.magistu.siegemachines.client.renderer.MachineItemGeoRenderer;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.ProjectileBuilder;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MachineItem<T extends Machine>
extends Item
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<EntityType<T>> entitytype;
    private final Supplier<MachineType> machinetype;

    public MachineItem(Item.Properties prop, Supplier<EntityType<T>> entitytype, Supplier<MachineType> machinetype) {
        super(prop.stacksTo(1));
        this.entitytype = entitytype;
        this.machinetype = machinetype;
    }

    public MachineItemGeoRenderer<T> getRenderer() {
        throw new NotImplementedException(MessageFormat.format("No renderer registered for {0} item", this.entitytype.get().toString()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"siegemachines.usage", (Object[])new Object[]{KeyBindings.getUseKey(this.machinetype.get()).getTranslatedKeyMessage()}).withStyle(ChatFormatting.BLUE));
        ProjectileBuilder<?>[] ammo = this.machinetype.get().ammo;
        if (ammo.length > 0) {
            tooltip.add((Component)Component.translatable((String)"siegemachines.ammo").withStyle(ChatFormatting.BLUE));
            for (ProjectileBuilder<?> builder : ammo) {
                if (this.machinetype.get().usesgunpowder) {
                    tooltip.add((Component)Component.translatable((String)"siegemachines.uses_gunpowder").withStyle(ChatFormatting.BLUE));
                }
                tooltip.add((Component)Component.literal((String)"    ").append((Component)Component.translatable((String)builder.item.getDescriptionId())).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity tileentity;
        Level world = context.getLevel();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = world.getBlockState(blockpos);
        CustomData data = (CustomData)itemstack.get(DataComponents.ENTITY_DATA);
        if (blockstate.is(Blocks.SPAWNER) && (tileentity = world.getBlockEntity(blockpos)) instanceof SpawnerBlockEntity) {
            BaseSpawner abstractspawner = ((SpawnerBlockEntity)tileentity).getSpawner();
            EntityType<T> entitytype1 = this.getType(data);
            abstractspawner.setEntityId(entitytype1, world, world.random, blockpos);
            tileentity.setChanged();
            world.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            itemstack.shrink(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos2 = blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType<T> entitytype = this.getType(data);
        Machine machine = this.spawn(entitytype, (ServerLevel)world, itemstack, context.getPlayer(), blockpos2, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos2) && direction == Direction.UP, context.getRotation());
        if (machine != null) {
            if (data != null) {
                machine.readAdditionalSaveData(data.copyTag());
            }
            machine.applyAttributeSpecs();
            machine.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
            machine.setDeploymentTicks((Integer)SpecsConfig.DEPLOYMENT_SICKNESS_COOLDOWN.get());
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    protected static double getYOffset(LevelReader reader, BlockPos pos, boolean bl, AABB aabb) {
        AABB axisalignedbb = new AABB(pos);
        if (bl) {
            axisalignedbb = axisalignedbb.expandTowards(0.0, -1.0, 0.0);
        }
        Iterable iterable = reader.getCollisions(null, axisalignedbb);
        return 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)aabb, (Iterable)iterable, (double)(bl ? -2.0 : -1.0));
    }

    @Nullable
    private Machine spawn(EntityType<T> entitytype, ServerLevel level, ItemStack stack, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        return this.spawn(entitytype, level, (CustomData)stack.get(DataComponents.CUSTOM_DATA), stack.getHoverName(), player, pos, type, bl, bl2, yaw);
    }

    @Nullable
    private Machine spawn(EntityType<T> entitytype, ServerLevel level, @Nullable CustomData nbt, @Nullable Component component, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        Machine machine = this.create(entitytype, level, nbt, component, player, pos, type, bl, bl2, yaw);
        if (machine != null) {
            level.addFreshEntityWithPassengers((Entity)machine);
        }
        return machine;
    }

    @Nullable
    private Machine create(EntityType<T> entitytype, ServerLevel level, @Nullable CustomData nbt, @Nullable Component component, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        double d0;
        Machine machine = (Machine)entitytype.create((Level)level);
        if (machine == null) {
            return null;
        }
        if (bl) {
            machine.setPos((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
            d0 = MachineItem.getYOffset((LevelReader)level, pos, bl2, machine.getBoundingBox());
        } else {
            d0 = 0.0;
        }
        if (nbt != null) {
            EntityType.updateCustomEntityTag((Level)level, (Player)player, (Entity)machine, (CustomData)nbt);
        }
        if (component != null) {
            machine.setCustomName(component);
        }
        machine.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + d0, (double)pos.getZ() + 0.5, Mth.wrapDegrees((float)yaw), 0.0f);
        machine.yHeadRot = machine.getYRot();
        machine.yBodyRot = machine.getYRot();
        machine.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(machine.blockPosition()), type, null);
        machine.playAmbientSound();
        return machine;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult raytraceresult = MachineItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, raytraceresult.getDirection(), itemstack)) {
            CustomData data = (CustomData)itemstack.get(DataComponents.ENTITY_DATA);
            EntityType<T> entitytype = this.getType(data);
            Machine machine = this.spawn(entitytype, (ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false, player.getYRot());
            if (machine != null) {
                if (data != null) {
                    machine.readAdditionalSaveData(data.copyTag());
                }
                machine.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
                machine.setDeploymentTicks((Integer)SpecsConfig.DEPLOYMENT_SICKNESS_COOLDOWN.get());
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.consume((Object)itemstack);
            }
            return InteractionResultHolder.pass((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    private EntityType<T> getType(@Nullable CustomData nbt) {
        CompoundTag compoundnbt;
        EntityType<T> defaulttype = this.entitytype.get();
        if (nbt != null && (compoundnbt = nbt.getUnsafe()).contains("id", 8)) {
            return EntityType.byString((String)compoundnbt.getString("id")).orElse(defaulttype);
        }
        return defaulttype;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

