/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.plugin.rei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.block.ModBlocks;
import ru.magistu.siegemachines.item.recipes.SiegeWorkbenchRecipe;
import ru.magistu.siegemachines.plugin.rei.SiegeWorkbenchRecipeDisplay;

public class SiegeWorkbenchCategory
implements DisplayCategory<SiegeWorkbenchRecipeDisplay> {
    public static final CategoryIdentifier<SiegeWorkbenchRecipeDisplay> ID = CategoryIdentifier.of((ResourceLocation)SiegeWorkbenchRecipe.TYPE_ID);

    @NotNull
    public CategoryIdentifier<SiegeWorkbenchRecipeDisplay> getCategoryIdentifier() {
        return ID;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"rei.category.siegemachines.siege_workbench");
    }

    @NotNull
    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)new ItemStack((ItemLike)ModBlocks.SIEGE_WORKBENCH.get()));
    }

    @NotNull
    public List<Widget> setupDisplay(SiegeWorkbenchRecipeDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int startX = bounds.x + 10;
        int startY = bounds.y + 10;
        for (int y = 0; y < display.getRecipe().pattern.height(); ++y) {
            for (int x = 0; x < display.getRecipe().pattern.width(); ++x) {
                int index = y * display.getRecipe().pattern.width() + x;
                if (index < display.getInputEntries().size()) {
                    widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + x * 18, startY + y * 18)).entries((Collection)display.getInputEntries().get(index)).markInput());
                    continue;
                }
                widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + x * 18, startY + y * 18)).markInput());
            }
        }
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startX + 18 * display.getRecipe().pattern.width() + 5, startY + 18)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 18 * display.getRecipe().pattern.width() + 5 + 30, startY + 18)).entries((Collection)display.getOutputEntries().get(0)).markOutput());
        return widgets;
    }

    public int getDisplayWidth(SiegeWorkbenchRecipeDisplay display) {
        return 160;
    }

    public int getDisplayHeight() {
        return 70;
    }
}

