/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.goblintraders.client.renderer.entity.GoblinModelLayers;
import com.mrcrayfish.goblintraders.client.renderer.entity.model.GoblinTraderModel;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class GoblinTraderRenderer
extends MobRenderer<AbstractGoblinEntity, GoblinTraderModel> {
    public GoblinTraderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GoblinTraderModel(context.bakeLayer(GoblinModelLayers.GOBLIN_TRADER)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractGoblinEntity entity) {
        return entity.getTexture();
    }

    protected void setupRotations(AbstractGoblinEntity entity, PoseStack pose, float p_115319_, float p_115320_, float partialTick, float p_320045_) {
        super.setupRotations((LivingEntity)entity, pose, p_115319_, p_115320_, partialTick, p_320045_);
        ((GoblinTraderModel)this.model).headTilt = entity.getHeadTilt(partialTick);
        ((GoblinTraderModel)this.model).armAngle = entity.getArmAngle(partialTick);
    }

    public void render(AbstractGoblinEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        poseStack.pushPose();
        if (entity.isUsingItem() || entity.isSitting()) {
            poseStack.translate(0.0, -0.17, 0.0);
        }
        if (entity.isStunned() && entity.isAlive()) {
            float progress = Math.min(10.0f, (float)entity.getFallCounter() + partialTicks) / 10.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getStunRotation()));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f * progress));
            poseStack.mulPose(Axis.YP.rotationDegrees(entity.getStunRotation()));
        }
        super.render((LivingEntity)entity, 0.0f, partialTicks, poseStack, source, light);
        poseStack.popPose();
    }
}

