/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config.formats;

import com.hypherionmc.craterlib.core.config.formats.AbstractConfigFormat;
import java.io.File;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.UnmodifiableConfig;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.file.FileConfig;

public class JsonConfigFormat<S>
extends AbstractConfigFormat<S> {
    public JsonConfigFormat(File configPath, Runnable afterSave) {
        super(configPath, afterSave);
    }

    @Override
    public void saveConfig(S conf) {
        ObjectConverter converter = new ObjectConverter();
        Object config = FileConfig.builder(this.getConfigPath()).sync().build();
        converter.toConfig((Object)conf, (Config)config);
        config.save();
        this.getOnSave().run();
    }

    @Override
    public S readConfig(S conf) {
        ObjectConverter converter = new ObjectConverter();
        Object config = FileConfig.builder(this.getConfigPath()).sync().build();
        config.load();
        converter.toObject((UnmodifiableConfig)config, conf);
        return conf;
    }

    @Override
    public void migrateConfig(S conf) {
        Object config = FileConfig.builder(this.getConfigPath()).build();
        Object newConfig = FileConfig.builder(this.getConfigPath()).sync().build();
        config.load();
        if (this.wasConfigChanged((Config)config, (Config)newConfig)) {
            new ObjectConverter().toConfig((Object)conf, (Config)newConfig);
            this.updateConfigValues((Config)config, (Config)newConfig, (Config)newConfig, "");
            newConfig.save();
        }
        config.close();
        newConfig.close();
    }

    public void updateConfigValues(Config oldConfig, Config newConfig, Config outputConfig, String subKey) {
        newConfig.valueMap().forEach((key, value) -> {
            String finalKey = subKey + (subKey.isEmpty() ? "" : ".") + key;
            if (value instanceof Config) {
                Config commentedConfig = (Config)value;
                this.updateConfigValues(oldConfig, commentedConfig, outputConfig, finalKey);
            } else {
                outputConfig.set(finalKey, oldConfig.contains(finalKey) ? oldConfig.get(finalKey) : value);
            }
        });
    }
}

