/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.natamus.areas_common_forge.data.AreaVariables;
import com.natamus.areas_common_forge.functions.ZoneFunctions;
import com.natamus.areas_common_forge.objects.AreaObject;
import com.natamus.areas_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.FABFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ClientCommandAreas {
    private static final Minecraft mc = Minecraft.getInstance();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"areas").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player)).executes(command -> ClientCommandAreas.areas((Player)ClientCommandAreas.mc.player)));
    }

    public static int areas(Player player) {
        if (player == null) {
            return 0;
        }
        Level level = player.level();
        Vec3 pvec = player.position();
        boolean sentfirst = false;
        List blockEntitiesAround = FABFunctions.getBlockEntitiesAroundPosition((Level)level, (BlockPos)player.blockPosition(), (Integer)200);
        for (BlockEntity nearbyBlockEntity : blockEntitiesAround) {
            BlockState blockEntityState = nearbyBlockEntity.getBlockState();
            if (!blockEntityState.is(BlockTags.ALL_SIGNS) && !blockEntityState.is(BlockTags.ALL_HANGING_SIGNS)) continue;
            BlockPos signPos = nearbyBlockEntity.getBlockPos();
            if (!ZoneFunctions.hasZonePrefix((SignBlockEntity)nearbyBlockEntity)) continue;
            if (!sentfirst) {
                MessageFunctions.sendMessage((Player)player, (String)"Area sign positions around you:", (ChatFormatting)ChatFormatting.DARK_GREEN);
                sentfirst = true;
            }
            Object prefix = "a";
            if (((HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.areaObjects, (Object)level, k -> new HashMap())).containsKey(signPos)) {
                AreaObject ao = AreaVariables.areaObjects.get(level).get(signPos);
                prefix = ao.areaName + " a";
            } else {
                Util.getAreaSign(level, signPos);
            }
            double distance = (double)Math.round(Math.sqrt(signPos.distSqr(new Vec3i(Mth.floor((double)pvec.x), Mth.floor((double)pvec.y), Mth.floor((double)pvec.z)))) * 100.0) / 100.0;
            String blocksaway = " (" + distance + " blocks)";
            MessageFunctions.sendMessage((Player)player, (String)(" " + (String)prefix + "t x=" + signPos.getX() + ", y=" + signPos.getY() + ", z=" + signPos.getZ() + "." + blocksaway), (ChatFormatting)ChatFormatting.YELLOW);
        }
        if (!sentfirst) {
            MessageFunctions.sendMessage((Player)player, (String)"There are no area signs around you.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        return 1;
    }
}

