/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.CraftingBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingBowlBlock
extends BaseEntityBlock {
    public static final MapCodec<CraftingBowlBlock> CODEC = CraftingBowlBlock.simpleCodec(CraftingBowlBlock::new);
    public static final int STIRS_NEEDED = 50;
    public static final IntegerProperty STIRRING = IntegerProperty.create((String)"stirring", (int)0, (int)32);
    public static final IntegerProperty STIRRED = IntegerProperty.create((String)"stirred", (int)0, (int)100);

    public CraftingBowlBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STIRRING, (Comparable)Integer.valueOf(0)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STIRRED, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Shapes.or((VoxelShape)CraftingBowlBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape)CraftingBowlBlock.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)).move(offset.x, offset.y, offset.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STIRRING});
        builder.add(new Property[]{STIRRED});
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof CraftingBowlBlockEntity)) {
            return InteractionResult.PASS;
        }
        CraftingBowlBlockEntity bowl = (CraftingBowlBlockEntity)be;
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean anyHeld = !main.isEmpty() || !off.isEmpty();
        int stirring = (Integer)state.getValue((Property)STIRRING);
        int stirred = (Integer)state.getValue((Property)STIRRED);
        if (player.isShiftKeyDown() && !anyHeld) {
            for (int i = 0; i < bowl.getContainerSize(); ++i) {
                ItemStack stack = bowl.getItem(i);
                if (stack.isEmpty()) continue;
                CraftingBowlBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                bowl.setItem(i, ItemStack.EMPTY);
            }
            bowl.setChanged();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (anyHeld && stirring == 0) {
            ItemStack src;
            ItemStack itemStack = src = !main.isEmpty() ? main : off;
            if (bowl.canAddItem()) {
                ItemStack one = src.copy();
                one.setCount(1);
                bowl.addItemStack(one);
                if (!player.isCreative()) {
                    src.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (!anyHeld) {
            ItemStack out;
            if (stirred >= 50 && stirring == 0 && !(out = bowl.getItem(4)).isEmpty()) {
                player.getInventory().add(out.copy());
                bowl.setItem(4, ItemStack.EMPTY);
                level.setBlock(pos, (BlockState)state.setValue((Property)STIRRED, (Comparable)Integer.valueOf(0)), 3);
                return InteractionResult.SUCCESS;
            }
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                RandomSource r = server.random;
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = bowl.getItem(i);
                    if (stack.isEmpty()) continue;
                    server.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 1, r.nextGaussian() * 0.15, 0.05, r.nextGaussian() * 0.15, 0.05);
                }
            }
            if (stirring <= 6) {
                level.setBlock(pos, (BlockState)state.setValue((Property)STIRRING, (Comparable)Integer.valueOf(10)), 3);
                bowl.addWhiskImpulse(0.35f);
                level.playSound(null, pos, (SoundEvent)SoundEventRegistry.CRAFTING_BOWL_STIRRING.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.getBlockState(pos.below()).getShape((BlockGetter)world, pos.below());
        Direction direction = Direction.UP;
        return Block.isFaceFull((VoxelShape)shape, (Direction)direction);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CraftingBowlBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CraftingBowlBlockEntity) {
                CraftingBowlBlockEntity be = (CraftingBowlBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CraftingBowlBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.CRAFTING_BOWL_BLOCK_ENTITY.get()), (w, p, s, be) -> be.tick(w, p, s, (CraftingBowlBlockEntity)be));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(ChatFormatting.GRAY));
    }
}

