/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.block.entity.RopeKnotBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class RopeKnotBlock
extends BaseEntityBlock {
    public static final MapCodec<RopeKnotBlock> CODEC = RopeKnotBlock.simpleCodec(RopeKnotBlock::new);
    private static final VoxelShape POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape KNOT = Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)POST, (VoxelShape)KNOT);
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");

    public RopeKnotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RopeKnotBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        RopeKnotBlockEntity be;
        BlockState held;
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof RopeKnotBlockEntity && (held = (be = (RopeKnotBlockEntity)((Object)object)).getHeldBlock()) != null && !held.isAir()) {
            drops.add(new ItemStack((ItemLike)held.getBlock().asItem()));
        }
        return drops;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof ShearsItem || player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof RopeKnotBlockEntity) {
                RopeKnotBlockEntity be = (RopeKnotBlockEntity)blockEntity;
                RopeKnotBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.ROPE.get()));
                BlockState held = be.getHeldBlock();
                if (held != null && !held.isAir()) {
                    level.setBlock(pos, held, 11);
                } else {
                    level.removeBlock(pos, false);
                }
                level.playSound(player, pos, SoundEvents.LEASH_KNOT_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (stack.getItem() instanceof ShearsItem) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
                this.updateNeighbors(level, pos);
            }
            return level.isClientSide ? ItemInteractionResult.CONSUME : ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        RopeKnotBlockEntity be;
        BlockState held;
        BlockEntity blockEntity;
        if (dir.getAxis().isHorizontal()) {
            boolean connected = this.connectsTo(neighborState, dir);
            state = (BlockState)state.setValue((Property)this.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(connected));
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof RopeKnotBlockEntity && (held = (be = (RopeKnotBlockEntity)blockEntity).getHeldBlock()) != null) {
            BlockState updated = held.updateShape(dir, neighborState, level, pos, neighborPos);
            be.setHeldBlock(updated);
        }
        return state;
    }

    private BooleanProperty getPropertyForDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> throw new IllegalArgumentException();
        };
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    private boolean connectsTo(BlockState neighbor, Direction dirTowardNeighbor) {
        if (neighbor.getBlock() instanceof RopeBlock) {
            Direction needOnNeighbor = dirTowardNeighbor.getOpposite();
            return (Boolean)neighbor.getValue((Property)RopeKnotBlock.ropeProp(needOnNeighbor));
        }
        return false;
    }

    private static BooleanProperty ropeProp(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> RopeBlock.NORTH;
            case Direction.SOUTH -> RopeBlock.SOUTH;
            case Direction.EAST -> RopeBlock.EAST;
            case Direction.WEST -> RopeBlock.WEST;
            default -> throw new IllegalArgumentException();
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = this.defaultBlockState();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            state = (BlockState)state.setValue((Property)this.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(this.connectsTo(level.getBlockState(pos.relative(dir)), dir)));
        }
        return state;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        if (!level.isClientSide && !state.is(oldState.getBlock())) {
            this.updateNeighbors(level, pos);
        }
        super.onPlace(state, level, pos, oldState, moved);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!level.isClientSide && !state.is(newState.getBlock())) {
            this.updateNeighbors(level, pos);
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    private void updateNeighbors(Level level, BlockPos pos) {
        level.updateNeighborsAt(pos, (Block)this);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos n = pos.relative(d);
            level.updateNeighborsAt(n, level.getBlockState(n).getBlock());
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)7.0, (double)11.0, (double)0.0, (double)9.0, (double)13.0, (double)5.0));
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)7.0, (double)11.0, (double)11.0, (double)9.0, (double)13.0, (double)16.0));
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0));
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)11.0, (double)11.0, (double)7.0, (double)16.0, (double)13.0, (double)9.0));
        }
        return shape;
    }
}

