/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.client.gui.handler.RoasterGuiHandler;
import net.satisfy.farm_and_charm.client.gui.handler.StoveGuiHandler;
import net.satisfy.farm_and_charm.core.compat.jei.category.CookingPotCategory;
import net.satisfy.farm_and_charm.core.compat.jei.category.CraftingBowlCategory;
import net.satisfy.farm_and_charm.core.compat.jei.category.MincerCategory;
import net.satisfy.farm_and_charm.core.compat.jei.category.RoasterCategory;
import net.satisfy.farm_and_charm.core.compat.jei.category.SiloCategory;
import net.satisfy.farm_and_charm.core.compat.jei.category.StoveCategory;
import net.satisfy.farm_and_charm.core.compat.jei.transfer.CookingPotTransferInfo;
import net.satisfy.farm_and_charm.core.compat.jei.transfer.RoasterTransferInfo;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;
import net.satisfy.farm_and_charm.core.recipe.CraftingBowlRecipe;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.recipe.RoasterRecipe;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.recipe.StoveRecipe;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.ScreenhandlerTypeRegistry;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class FarmAndCharmJEIPlugin
implements IModPlugin {
    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StoveCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CraftingBowlCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RoasterCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SiloCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MincerCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List cookingHoldersRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        ArrayList cookingPotRecipes = new ArrayList();
        cookingHoldersRecipes.iterator().forEachRemaining(recipeHolder -> cookingPotRecipes.add((CookingPotRecipe)recipeHolder.value()));
        registration.addRecipes(CookingPotCategory.COOKING_POT, cookingPotRecipes);
        List stoveHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get());
        ArrayList stoveRecipes = new ArrayList();
        stoveHolderRecipes.iterator().forEachRemaining(recipeHolder -> stoveRecipes.add((StoveRecipe)recipeHolder.value()));
        registration.addRecipes(StoveCategory.STOVE, stoveRecipes);
        List doughingHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get());
        ArrayList doughingRecipes = new ArrayList();
        doughingHolderRecipes.iterator().forEachRemaining(recipeHolder -> doughingRecipes.add((CraftingBowlRecipe)recipeHolder.value()));
        registration.addRecipes(CraftingBowlCategory.DOUGHING, doughingRecipes);
        List roasterHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.ROASTER_RECIPE_TYPE.get());
        ArrayList roasterRecipes = new ArrayList();
        roasterHolderRecipes.iterator().forEachRemaining(recipeHolder -> roasterRecipes.add((RoasterRecipe)recipeHolder.value()));
        registration.addRecipes(RoasterCategory.ROASTER, roasterRecipes);
        List siloHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.SILO_RECIPE_TYPE.get());
        ArrayList siloRecipes = new ArrayList();
        siloHolderRecipes.iterator().forEachRemaining(recipeHolder -> siloRecipes.add((SiloRecipe)recipeHolder.value()));
        registration.addRecipes(SiloCategory.DRYING_TYPE, siloRecipes);
        List mincerHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get());
        ArrayList mincerRecipes = new ArrayList();
        mincerHolderRecipes.iterator().forEachRemaining(recipeHolder -> mincerRecipes.add((MincerRecipe)recipeHolder.value()));
        registration.addRecipes(MincerCategory.MINCING_TYPE, mincerRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return FarmAndCharm.identifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new RoasterTransferInfo());
        registration.addRecipeTransferHandler(RoasterGuiHandler.class, (MenuType)ScreenhandlerTypeRegistry.ROASTER_SCREEN_HANDLER.get(), RoasterCategory.ROASTER, 1, 3, 5, 36);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingPotTransferInfo());
        registration.addRecipeTransferHandler(StoveGuiHandler.class, (MenuType)ScreenhandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), StoveCategory.STOVE, 1, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.COOKING_POT.get()).asItem().getDefaultInstance(), new RecipeType[]{CookingPotCategory.COOKING_POT});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.CRAFTING_BOWL.get()).asItem().getDefaultInstance(), new RecipeType[]{CraftingBowlCategory.DOUGHING});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.STOVE.get()).asItem().getDefaultInstance(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.ROASTER.get()).asItem().getDefaultInstance(), new RecipeType[]{RoasterCategory.ROASTER});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.MINCER.get()).asItem().getDefaultInstance(), new RecipeType[]{MincerCategory.MINCING_TYPE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.SILO_WOOD.get()).asItem().getDefaultInstance(), new RecipeType[]{SiloCategory.DRYING_TYPE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.SILO_COPPER.get()).asItem().getDefaultInstance(), new RecipeType[]{SiloCategory.DRYING_TYPE});
    }
}

