/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.satisfy.farm_and_charm.platform.PlatformHelper;

public class SatiationEffect
extends MobEffect {
    public SatiationEffect() {
        super(MobEffectCategory.BENEFICIAL, -10496);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int healAmount = PlatformHelper.getSatiationEffectHealAmount();
            if (player.getFoodData().needsFood() || player.hasEffect(MobEffects.REGENERATION) || player.getFoodData().getSaturationLevel() <= 0.0f) {
                return false;
            }
            player.heal((float)(healAmount + amplifier));
            return true;
        }
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int interval = Math.max(1, PlatformHelper.getSatiationEffectInterval());
        return duration % interval == 0;
    }
}

