/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.FertilizedFarmlandBlock;
import net.satisfy.farm_and_charm.core.entity.AbstractTowableEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class PlowCartEntity
extends AbstractTowableEntity {
    public PlowCartEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    @Override
    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.08, 0.0));
        }
        super.tick();
        this.tickLerp();
        if (this.driver != null) {
            this.pulledTick();
        }
        this.leftWheel.tick();
        this.rightWheel.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.level().isClientSide()) {
            this.handleClientSide();
        } else {
            this.handleServerSide();
        }
    }

    private void handleClientSide() {
        BlockPos[] positions;
        BlockPos currentPos = this.blockPosition();
        for (BlockPos pos : positions = new BlockPos[]{currentPos.below(), currentPos.below().east()}) {
            BlockState blockState = this.level().getBlockState(pos);
            BlockState newBlockState = null;
            if (blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.DIRT)) {
                newBlockState = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(0));
            } else if (blockState.is((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get())) {
                newBlockState = (BlockState)((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get()).defaultBlockState().setValue((Property)FertilizedFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(0));
            }
            if (newBlockState == null) continue;
            for (int i = 0; i < 200; ++i) {
                double x = (double)pos.getX() + this.level().random.nextDouble();
                double y = (double)pos.getY() + this.level().random.nextDouble();
                double z = (double)pos.getZ() + this.level().random.nextDouble();
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, newBlockState), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void handleServerSide() {
        BlockPos[] positions;
        BlockPos currentPos = this.blockPosition();
        for (BlockPos pos : positions = new BlockPos[]{currentPos.below(), currentPos.below().east()}) {
            CropBlock cropBlock;
            BlockState blockState = this.level().getBlockState(pos);
            BlockState newBlockState = null;
            if (blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.DIRT)) {
                newBlockState = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(0));
            } else if (blockState.is((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get())) {
                newBlockState = (BlockState)((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get()).defaultBlockState().setValue((Property)FertilizedFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(0));
            }
            if (newBlockState != null) {
                this.level().setBlock(pos, newBlockState, 3);
            }
            BlockPos cropPos = pos.above();
            BlockState cropState = this.level().getBlockState(cropPos);
            Block block = cropState.getBlock();
            if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).isMaxAge(cropState)) continue;
            BlockState newCropState = cropBlock.getStateForAge(0);
            this.level().setBlock(cropPos, newCropState, 3);
            this.level().updateNeighborsAt(cropPos, newCropState.getBlock());
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            for (ItemStack drop : Block.getDrops((BlockState)cropState, (ServerLevel)serverLevel, (BlockPos)cropPos, null)) {
                if (drop.isEmpty()) continue;
                double dropX = (double)cropPos.getX() + 0.5 + (this.level().random.nextDouble() - 0.5) * 0.5;
                double dropY = (double)cropPos.getY() + 1.0;
                double dropZ = (double)cropPos.getZ() + 0.5 + (this.level().random.nextDouble() - 0.5) * 0.5;
                ItemEntity itemEntity = new ItemEntity(this.level(), dropX, dropY, dropZ, drop);
                this.level().addFreshEntity((Entity)itemEntity);
            }
        }
    }

    @Override
    protected ItemStack getDropItem() {
        return new ItemStack((ItemLike)ObjectRegistry.PLOW.get());
    }
}

